/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.common.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.machinemuse.numina.common.item.IModeChangingItem;
import net.machinemuse.numina.common.item.IModularItem;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.IEnchantmentModule;
import net.machinemuse.numina.common.module.IPowerModule;
import net.machinemuse.numina.common.module.IRightClickModule;
import net.machinemuse.numina.common.nbt.MuseNBTUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;

public interface IModuleManager {
    public void addModule(IPowerModule var1);

    public NonNullList<IPowerModule> getAllModules();

    public Map<String, IPowerModule> getModuleMap();

    @Nullable
    public IPowerModule getModule(String var1);

    default public NonNullList<IPowerModule> getModulesOfType(Class<? extends IPowerModule> type) {
        NonNullList retList = NonNullList.func_191196_a();
        for (IPowerModule module : this.getModuleMap().values()) {
            if (!type.isAssignableFrom(module.getClass())) continue;
            retList.add((Object)module);
        }
        return retList;
    }

    public boolean isValidForItem(@Nonnull ItemStack var1, String var2);

    public boolean isValidForItem(@Nonnull ItemStack var1, IPowerModule var2);

    default public double computeModularPropertyDouble(@Nonnull ItemStack stack, String propertyName) {
        return (Double)this.computeModularProperty(stack, propertyName);
    }

    default public double getOrSetModularPropertyDouble(@Nonnull ItemStack stack, String propertyName) {
        double propertyValue = 0.0;
        NBTTagCompound valuesTag = MuseNBTUtils.getMuseValuesTag(stack);
        if (!valuesTag.func_150297_b(propertyName, 6)) {
            propertyValue = this.computeModularPropertyDouble(stack, propertyName);
            if (propertyValue > 0.0) {
                valuesTag.func_74780_a(propertyName, propertyValue);
            }
        } else {
            propertyValue = valuesTag.func_74769_h(propertyName);
            if (propertyValue == 0.0) {
                valuesTag.func_82580_o(propertyName);
            }
        }
        return propertyValue;
    }

    default public Object computeModularProperty(@Nonnull ItemStack stack, String propertyName) {
        double propertyValue = 0.0;
        NBTTagCompound itemTag = MuseNBTUtils.getMuseItemTag(stack);
        for (IPowerModule module : this.getAllModules()) {
            if (!this.itemHasActiveModule(stack, module.getDataName())) continue;
            propertyValue = module.applyPropertyModifiers(itemTag, propertyName, propertyValue);
        }
        return propertyValue;
    }

    default public List<IPowerModule> getValidModulesForItem(@Nonnull ItemStack stack) {
        ArrayList<IPowerModule> validModules = new ArrayList<IPowerModule>();
        for (IPowerModule module : this.getAllModules()) {
            if (!this.isValidForItem(stack, module.getDataName())) continue;
            validModules.add(module);
        }
        return validModules;
    }

    default public boolean itemHasModule(@Nonnull ItemStack stack, String moduleName) {
        return this.tagHasModule(MuseNBTUtils.getMuseItemTag(stack), moduleName);
    }

    default public boolean tagHasModule(NBTTagCompound tag, String moduleName) {
        return tag != null ? tag.func_74764_b(moduleName) : false;
    }

    default public void tagAddModule(NBTTagCompound tag, IPowerModule module) {
        tag.func_74782_a(module.getDataName(), (NBTBase)module.getNewTag());
    }

    default public boolean toggleModule(NBTTagCompound itemTag, String name, boolean toggleval) {
        if (this.tagHasModule(itemTag, name)) {
            NBTTagCompound moduleTag = itemTag.func_74775_l(name);
            moduleTag.func_74757_a("Active", toggleval);
            return true;
        }
        return false;
    }

    default public void toggleModuleForPlayer(EntityPlayer player, String dataName, boolean toggleval) {
        IPowerModule module = this.getModuleMap().get(dataName);
        for (ItemStack stack : MuseItemUtils.getModularItemsEquipped(player)) {
            NBTTagCompound itemTag = MuseNBTUtils.getMuseItemTag(stack);
            if (!this.toggleModule(itemTag, dataName, toggleval) || !(module instanceof IEnchantmentModule)) continue;
            if (toggleval) {
                ((IEnchantmentModule)module).addEnchantment(stack);
                continue;
            }
            ((IEnchantmentModule)module).removeEnchantment(stack);
        }
    }

    default public int getNumberInstalledModulesOfType(@Nonnull ItemStack stack, EnumModuleCategory category) {
        int matches = 0;
        NBTTagCompound itemTag = MuseNBTUtils.getMuseItemTag(stack);
        for (IPowerModule module : this.getValidModulesForItem(stack)) {
            if (!this.tagHasModule(itemTag, module.getDataName()) || module.getCategory() != category) continue;
            ++matches;
        }
        return matches;
    }

    default public List<IPowerModule> getItemInstalledModules(@Nonnull ItemStack stack) {
        ArrayList<IPowerModule> installedModules = new ArrayList<IPowerModule>();
        NBTTagCompound itemTag = MuseNBTUtils.getMuseItemTag(stack);
        for (IPowerModule module : this.getValidModulesForItem(stack)) {
            if (!this.tagHasModule(itemTag, module.getDataName())) continue;
            installedModules.add(module);
        }
        return installedModules;
    }

    default public List<IPowerModule> getPlayerInstalledModules(EntityPlayer player) {
        ArrayList<IPowerModule> installedModules = new ArrayList<IPowerModule>();
        for (ItemStack stack : MuseItemUtils.getModularItemsEquipped(player)) {
            NBTTagCompound itemTag = MuseNBTUtils.getMuseItemTag(stack);
            for (IPowerModule module : this.getValidModulesForItem(stack)) {
                if (!this.tagHasModule(itemTag, module.getDataName())) continue;
                installedModules.add(module);
            }
        }
        return installedModules;
    }

    default public boolean isModuleOnline(@Nonnull ItemStack itemStack, String moduleName) {
        return this.isModuleOnline(MuseNBTUtils.getMuseItemTag(itemStack), moduleName);
    }

    default public boolean isModuleOnline(NBTTagCompound itemTag, String moduleName) {
        if (this.tagHasModule(itemTag, moduleName) && !itemTag.func_74775_l(moduleName).func_74764_b("Active")) {
            return true;
        }
        return this.tagHasModule(itemTag, moduleName) && itemTag.func_74775_l(moduleName).func_74767_n("Active");
    }

    default public void itemAddModule(@Nonnull ItemStack stack, IPowerModule moduleName) {
        IPowerModule module = this.getModuleMap().get(moduleName);
        if (module instanceof IEnchantmentModule) {
            ((IEnchantmentModule)module).addEnchantment(stack);
        }
        this.tagAddModule(MuseNBTUtils.getMuseItemTag(stack), moduleName);
    }

    default public boolean removeModule(NBTTagCompound tag, String moduleName) {
        if (tag.func_74764_b(moduleName)) {
            tag.func_82580_o(moduleName);
            return true;
        }
        return false;
    }

    default public boolean removeModule(@Nonnull ItemStack stack, String moduleName) {
        IPowerModule module = this.getModuleMap().get(moduleName);
        if (module instanceof IEnchantmentModule) {
            ((IEnchantmentModule)module).removeEnchantment(stack);
        }
        return this.removeModule(MuseNBTUtils.getMuseItemTag(stack), moduleName);
    }

    default public boolean itemHasActiveModule(@Nonnull ItemStack itemStack, String moduleName) {
        IPowerModule module = this.getModule(moduleName);
        if (module == null || itemStack.func_190926_b() || !module.isAllowed() || !(itemStack.func_77973_b() instanceof IModularItem)) {
            return false;
        }
        if (module instanceof IRightClickModule && itemStack.func_77973_b() instanceof IModeChangingItem) {
            IModeChangingItem item = (IModeChangingItem)itemStack.func_77973_b();
            return moduleName.equals(item.getActiveMode(itemStack));
        }
        return this.isModuleOnline(MuseNBTUtils.getMuseItemTag(itemStack), moduleName);
    }

    public NonNullList<ItemStack> getInstallCost(String var1);

    public void addInstallCost(String var1, @Nonnull ItemStack var2);

    public void addInstallCost(String var1, NonNullList<ItemStack> var2);

    public boolean hasCustomInstallCost(String var1);

    public NonNullList<ItemStack> getCustomInstallCost(String var1);

    public void addCustomInstallCost(String var1, @Nonnull ItemStack var2);
}

