/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.common.capabilities.heat;

import net.machinemuse.numina.common.capabilities.heat.IHeatStorage;

public class HeatStorage
implements IHeatStorage {
    protected double heat;
    protected double capacity;
    protected double maxReceive;
    protected double maxExtract;

    public HeatStorage(double capacity) {
        this(capacity, capacity, capacity, 0.0);
    }

    public HeatStorage(double capacity, double maxTransfer) {
        this(capacity, maxTransfer, maxTransfer, 0.0);
    }

    public HeatStorage(double capacity, double maxReceive, double maxExtract) {
        this(capacity, maxReceive, maxExtract, 0.0);
    }

    public HeatStorage(double capacity, double maxReceive, double maxExtract, double heat) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.heat = heat;
    }

    @Override
    public double receiveHeat(double maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0.0;
        }
        double heatReceived = maxReceive;
        if (!simulate) {
            this.heat += heatReceived;
        }
        return heatReceived;
    }

    @Override
    public double extractHeat(double maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0.0;
        }
        double heatExtracted = Math.min(this.heat, maxExtract);
        if (!simulate) {
            this.heat -= heatExtracted;
        }
        return heatExtracted;
    }

    @Override
    public double getHeatStored() {
        return this.heat;
    }

    @Override
    public double getMaxHeatStored() {
        return this.capacity;
    }

    @Override
    public boolean canExtract() {
        return this.heat > 0.0;
    }

    @Override
    public boolean canReceive() {
        return true;
    }
}

