/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.render.modelspec;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.machinemuse.numina.client.render.modelspec.EnumSpecType;
import net.machinemuse.numina.client.render.modelspec.PartSpecBase;
import net.machinemuse.numina.common.map.MuseRegistry;
import net.machinemuse.numina.common.math.Colour;

public abstract class SpecBase
extends MuseRegistry<PartSpecBase> {
    private final String name;
    private final boolean isDefault;
    private final EnumSpecType specType;
    private List<Integer> colours = new ArrayList(){
        {
            this.add(Colour.WHITE.getInt());
        }
    };

    public SpecBase(String name, boolean isDefault, EnumSpecType specType) {
        this.name = name;
        this.isDefault = isDefault;
        this.specType = specType;
    }

    public abstract String getDisaplayName();

    public Iterable<PartSpecBase> getPartSpecs() {
        return this.elems();
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public EnumSpecType getSpecType() {
        return this.specType;
    }

    public List<Integer> getColours() {
        return this.colours;
    }

    public int addColourIfNotExist(Colour colour) {
        int colourInt = colour.getInt();
        if (!this.colours.contains(colourInt)) {
            this.colours.add(colourInt);
            return this.colours.size() - 1;
        }
        return this.colours.indexOf(colourInt);
    }

    public abstract String getOwnName();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecBase specBase = (SpecBase)o;
        return this.isDefault == specBase.isDefault && Objects.equals(this.name, specBase.name) && this.specType == specBase.specType && Objects.equals(this.colours, specBase.colours);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.isDefault, this.specType, this.colours});
    }
}

