/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.gui.scrollable;

import javax.annotation.Nonnull;
import net.machinemuse.numina.client.gui.frame.AbstractGuiFrame;
import net.machinemuse.numina.client.gui.frame.IScrollable;
import net.machinemuse.numina.client.gui.geometry.IRect;
import net.machinemuse.numina.common.math.MuseMathUtils;

public class ScrollableFrame
extends AbstractGuiFrame
implements IScrollable {
    protected int buttonSize = 5;
    double scrollAmount = 8.0;
    protected int totalSize = 0;
    protected double currentScrollPixels = 0.0;

    public ScrollableFrame(@Nonnull IRect rect) {
        super(rect);
    }

    @Override
    public void render(double mouseX, double mouseY, float partialTick) {
        if (this.isVisible()) {
            this.renderBackgroundRect(mouseX, mouseY, partialTick);
            super.render(mouseX, mouseY, partialTick);
            this.preRender(mouseX, mouseY, partialTick);
            this.postRender(mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    @Override
    public int getButtonSize() {
        return this.buttonSize;
    }

    @Override
    public void setButtonSize(int buttonSize) {
        this.buttonSize = buttonSize;
    }

    @Override
    public int getTotalSize() {
        return this.totalSize;
    }

    @Override
    public double getCurrentScrollPixels() {
        return this.currentScrollPixels;
    }

    @Override
    public void setCurrentScrollPixels(double scrollPixels) {
        this.currentScrollPixels = MuseMathUtils.clampDouble(scrollPixels, 0.0, this.getMaxScrollPixels());
    }

    @Override
    public double getMaxScrollPixels() {
        return (int)Math.max((double)this.totalSize - this.height(), 0.0);
    }

    @Override
    public double getScrollAmount() {
        return this.scrollAmount;
    }

    @Override
    public void setScrollAmount(double scrollAmount) {
        this.scrollAmount = (int)MuseMathUtils.clampDouble(scrollAmount, 0.0, this.getMaxScrollPixels());
    }
}

