/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.gui.clickable;

import java.util.List;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;

public interface IClickable {
    public void render(double var1, double var3, float var5);

    public void move(double var1, double var3);

    public MusePoint2D getPosition();

    public void enable();

    public void disable();

    public void hide();

    public void show();

    default public void disableAndHide() {
        this.disable();
        this.hide();
    }

    default public void enableAndShow() {
        this.enable();
        this.show();
    }

    public boolean isEnabled();

    public boolean isVisible();

    public boolean containsPoint(double var1, double var3);

    public List getToolTip(double var1, double var3);

    public void setOnPressed(IPressable var1);

    public void setOnReleased(IReleasable var1);

    public void onPressed();

    public void onReleased();

    default public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.isVisible() && this.containsPoint(mouseX, mouseY)) {
            if (button == 0 || button == 1) {
                this.onPressed();
            }
            this.playPressSound(Minecraft.func_71410_x().func_147118_V());
            return true;
        }
        return false;
    }

    default public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isEnabled() && this.isVisible() && (button == 0 || button == 1)) {
            this.onReleased();
        }
        return false;
    }

    default public void playPressSound(SoundHandler soundHandlerIn) {
        soundHandlerIn.func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public static interface IReleasable {
        public void onReleased(IClickable var1);
    }

    public static interface IPressable {
        public void onPressed(IClickable var1);
    }
}

