/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.powermodule.tool;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.machinemuse.numina.common.energy.ElectricItemUtils;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.module.EnumModuleCategory;
import net.machinemuse.numina.common.module.EnumModuleTarget;
import net.machinemuse.numina.common.module.IBlockBreakingModule;
import net.machinemuse.numina.common.module.IRightClickModule;
import net.machinemuse.powersuits.common.base.ModuleManager;
import net.machinemuse.powersuits.common.item.ItemComponent;
import net.machinemuse.powersuits.common.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.common.utils.MusePlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ShearsModule
extends PowerModuleBase
implements IBlockBreakingModule,
IRightClickModule {
    private static final ItemStack emulatedTool = new ItemStack((Item)Items.field_151097_aZ);

    public ShearsModule(EnumModuleTarget moduleTarget) {
        super(moduleTarget);
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), new ItemStack(Items.field_151042_j, 2));
        ModuleManager.INSTANCE.addInstallCost(this.getDataName(), MuseItemUtils.copyAndResize((ItemStack)ItemComponent.solenoid, (int)1));
        this.addBasePropertyDouble("shearEnergyCon", 1000.0, "RF");
        this.addBasePropertyDouble("shearHarvSpd", 8.0, "x");
    }

    public EnumModuleCategory getCategory() {
        return EnumModuleCategory.CATEGORY_TOOL;
    }

    public String getDataName() {
        return "shears";
    }

    public ActionResult onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        Entity entity;
        IShearable target;
        if (playerIn.field_70170_p.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
        }
        RayTraceResult rayTraceResult = MusePlayerUtils.raytraceEntities(worldIn, playerIn, false, 8.0);
        if (rayTraceResult != null && rayTraceResult.field_72308_g instanceof IShearable && (target = (IShearable)rayTraceResult.field_72308_g).isShearable(itemStackIn, (IBlockAccess)entity.field_70170_p, new BlockPos(entity = rayTraceResult.field_72308_g))) {
            List drops = target.onSheared(itemStackIn, (IBlockAccess)entity.field_70170_p, new BlockPos(entity), EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (ItemStack)itemStackIn));
            Random rand = new Random();
            for (ItemStack drop : drops) {
                EntityItem ent = entity.func_70099_a(drop, 1.0f);
                ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
            }
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)playerIn, (int)((int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStackIn, "shearEnergyCon")));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
    }

    public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    public void onPlayerStoppedUsing(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
    }

    public int getEnergyUsage(@Nonnull ItemStack itemStack) {
        return (int)ModuleManager.INSTANCE.getOrSetModularPropertyDouble(itemStack, "shearEnergyCon");
    }

    public boolean onBlockDestroyed(ItemStack itemStack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving, int playerEnergy) {
        IShearable target;
        Block block;
        if (this.canHarvestBlock(itemStack, state, (EntityPlayer)entityLiving, pos, playerEnergy) && (block = state.func_177230_c()) instanceof IShearable && (target = (IShearable)block).isShearable(itemStack, (IBlockAccess)entityLiving.field_70170_p, pos)) {
            List drops = target.onSheared(itemStack, (IBlockAccess)entityLiving.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(entityLiving.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                entityitem.field_70170_p.func_72838_d((Entity)entityitem);
            }
            ElectricItemUtils.drainPlayerEnergy((EntityPlayer)((EntityPlayer)entityLiving), (int)this.getEnergyUsage(itemStack));
            ((EntityPlayer)entityLiving).func_71064_a(StatList.func_188055_a((Block)block), 1);
            return true;
        }
        return false;
    }

    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        float defaultEffectiveness = 8.0f;
        double ourEffectiveness = ModuleManager.INSTANCE.getOrSetModularPropertyDouble(event.getEntityPlayer().field_71071_by.func_70448_g(), "shearHarvSpd");
        event.setNewSpeed((float)((double)event.getNewSpeed() * Math.max((double)defaultEffectiveness, ourEffectiveness)));
    }

    @Override
    public TextureAtlasSprite getIcon(ItemStack item) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(emulatedTool).func_177554_e();
    }

    public ItemStack getEmulatedTool() {
        return emulatedTool;
    }
}

