/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.network.packets;

import io.netty.buffer.ByteBuf;
import net.machinemuse.numina.common.item.IModularItem;
import net.machinemuse.numina.common.nbt.MuseNBTUtils;
import net.machinemuse.numina.common.network.MuseByteBufferUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MusePacketColourInfo
implements IMessage {
    EntityPlayer player;
    int itemSlot;
    int[] tagData;

    public MusePacketColourInfo() {
    }

    public MusePacketColourInfo(EntityPlayer player, int itemSlot, int[] tagData) {
        this.player = player;
        this.itemSlot = itemSlot;
        this.tagData = tagData;
    }

    public void fromBytes(ByteBuf buf) {
        this.itemSlot = buf.readInt();
        this.tagData = MuseByteBufferUtils.readIntArray((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.itemSlot);
        MuseByteBufferUtils.writeIntArray((ByteBuf)buf, (int[])this.tagData);
    }

    public static class Handler
    implements IMessageHandler<MusePacketColourInfo, IMessage> {
        public IMessage onMessage(MusePacketColourInfo message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                player.func_71121_q().func_152344_a(() -> {
                    int itemSlot = message.itemSlot;
                    int[] tagData = message.tagData;
                    ItemStack stack = player.field_71071_by.func_70301_a(itemSlot);
                    if (!stack.func_190926_b() && stack.func_77973_b() instanceof IModularItem) {
                        NBTTagCompound itemTag = MuseNBTUtils.getMuseItemTag((ItemStack)stack);
                        NBTTagCompound renderTag = itemTag.func_74775_l("render");
                        if (renderTag == null) {
                            renderTag = new NBTTagCompound();
                            itemTag.func_74782_a("render", (NBTBase)renderTag);
                        }
                        if (renderTag != null) {
                            renderTag.func_74783_a("colours", tagData);
                        }
                    }
                });
            }
            return null;
        }
    }
}

