/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.gui.cosmetic;

import com.google.common.collect.BiMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.machinemuse.numina.client.gui.IDrawable;
import net.machinemuse.numina.client.gui.clickable.ClickableButton;
import net.machinemuse.numina.client.gui.clickable.ClickableItem;
import net.machinemuse.numina.client.gui.frame.IGuiFrame;
import net.machinemuse.numina.client.gui.geometry.DrawableMuseRect;
import net.machinemuse.numina.client.gui.geometry.IRect;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.gui.geometry.MuseRect;
import net.machinemuse.numina.client.gui.scrollable.ScrollableLabel;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.common.item.MuseItemUtils;
import net.machinemuse.numina.common.math.Colour;
import net.machinemuse.numina.common.nbt.MuseNBTUtils;
import net.machinemuse.powersuits.client.gui.common.ItemSelectionFrame;
import net.machinemuse.powersuits.client.gui.cosmetic.ColourPickerFrame;
import net.machinemuse.powersuits.client.gui.cosmetic.CosmeticPresetContainer;
import net.machinemuse.powersuits.client.gui.cosmetic.PartManipContainer;
import net.machinemuse.powersuits.client.render.modelspec.DefaultModelSpec;
import net.machinemuse.powersuits.common.config.CosmeticPresetSaveLoad;
import net.machinemuse.powersuits.common.config.MPSConfig;
import net.machinemuse.powersuits.common.item.armor.ItemPowerArmor;
import net.machinemuse.powersuits.common.item.tool.ItemPowerFist;
import net.machinemuse.powersuits.common.network.MPSPackets;
import net.machinemuse.powersuits.common.network.packets.MusePacketCosmeticInfo;
import net.machinemuse.powersuits.common.network.packets.MusePacketCosmeticPreset;
import net.machinemuse.powersuits.common.network.packets.MusePacketCosmeticPresetUpdate;
import net.machinemuse.powersuits.common.utils.nbt.MPSNBTUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class LoadSaveResetSubFrame<T extends IRect>
implements IGuiFrame {
    EntityPlayer player;
    public ItemSelectionFrame itemSelector;
    public T border;
    protected ClickableButton loadButton;
    protected ClickableButton saveButton;
    protected ClickableButton resetButton;
    ColourPickerFrame colourpicker;
    ScrollableLabel saveAsLabel;
    final boolean usingCosmeticPresets;
    final boolean allowCosmeticPresetCreation;
    final double originalBottom;
    final double originalTop;
    final double originalHeight;
    final double newHeight;
    protected PartManipContainer partframe;
    protected CosmeticPresetContainer cosmeticFrame;
    protected boolean isEditing;
    GuiTextField presetNameInputBox;

    public LoadSaveResetSubFrame(ColourPickerFrame colourpicker, EntityPlayer player, MuseRect borderRef, Colour insideColour, Colour borderColour, ItemSelectionFrame itemSelector, boolean usingCosmeticPresetsIn, boolean allowCosmeticPresetCreationIn, PartManipContainer partframe, CosmeticPresetContainer cosmeticFrame) {
        this.player = player;
        this.setRect((IRect)new DrawableMuseRect(borderRef, insideColour, borderColour));
        this.originalTop = this.border.top();
        this.originalHeight = this.border.height();
        this.originalBottom = this.border.bottom();
        this.newHeight = Math.abs(colourpicker.top() - this.originalBottom);
        double sizex = this.border.right() - this.border.left();
        double sizey = this.border.bottom() - this.border.top();
        this.itemSelector = itemSelector;
        this.colourpicker = colourpicker;
        this.saveAsLabel = new ScrollableLabel(I18n.func_135052_a((String)"gui.powersuits.saveAs", (Object[])new Object[0]), new MuseRect(this.border.left(), colourpicker.top() + 20.0, this.border.right(), colourpicker.top() + 30.0)).setEnabled(false);
        this.presetNameInputBox = new GuiTextField(0, MuseRenderer.getFontRenderer(), (int)this.border.left() + 2, (int)(this.saveAsLabel.bottom() + 10.0), (int)this.border.width() - 4, 20);
        this.loadButton = new ClickableButton(I18n.func_135052_a((String)"gui.powersuits.load", (Object[])new Object[0]), new MusePoint2D(this.border.left() + sizex * 2.5 / 12.0, this.border.bottom() - sizey / 2.0), true);
        this.saveButton = new ClickableButton(I18n.func_135052_a((String)"gui.powersuits.save", (Object[])new Object[0]), new MusePoint2D(this.border.right() - sizex * 2.5 / 12.0, this.border.bottom() - sizey / 2.0), true);
        this.resetButton = new ClickableButton(I18n.func_135052_a((String)"gui.powersuits.reset", (Object[])new Object[0]), new MusePoint2D(this.border.left() + sizex / 2.0, this.border.bottom() - sizey / 2.0), true);
        this.textInputOff();
        this.presetNameInputBox.func_146203_f((int)this.border.width());
        this.presetNameInputBox.func_146180_a("");
        this.usingCosmeticPresets = usingCosmeticPresetsIn;
        this.allowCosmeticPresetCreation = allowCosmeticPresetCreationIn;
        this.partframe = partframe;
        this.cosmeticFrame = cosmeticFrame;
        this.isEditing = false;
        if (this.usingCosmeticPresets) {
            if (this.allowCosmeticPresetCreation) {
                this.cosmeticPresetCreator();
            } else {
                this.cosmeticPresetsNormal();
            }
        } else {
            this.setLegacyMode();
        }
    }

    public IRect getRect() {
        return this.border;
    }

    public void setRect(IRect rect) {
        this.border = rect;
    }

    void setLegacyMode() {
        this.saveButton.buttonOff();
        this.loadButton.buttonOff();
        this.showPartManipFrame();
        this.colourPickerSetOpen();
    }

    void cosmeticPresetsNormal() {
        this.saveButton.buttonOff();
        this.loadButton.buttonOff();
        this.colourpickerSetClosed();
        this.textInputOff();
        this.showPresetFrame();
    }

    void cosmeticPresetCreator() {
        if (this.isEditing) {
            this.loadButton.buttonOn();
            this.loadButton.setLable(I18n.func_135052_a((String)"gui.powersuits.cancel", (Object[])new Object[0]));
            this.saveButton.buttonOn();
            this.saveButton.setLable(I18n.func_135052_a((String)"gui.powersuits.save", (Object[])new Object[0]));
            this.showPartManipFrame();
            if (this.presetNameInputBox.func_146176_q()) {
                this.colourpickerSetClosed();
            } else {
                this.colourPickerSetOpen();
            }
        } else {
            this.textInputOff();
            this.showPresetFrame();
            this.colourpickerSetClosed();
            this.loadButton.buttonOff();
            this.saveButton.buttonOn();
            this.saveButton.setLable(I18n.func_135052_a((String)"gui.powersuits.new", (Object[])new Object[0]));
        }
    }

    void colourPickerSetOpen() {
        this.border.setTop(this.originalTop).setHeight(this.originalHeight);
        this.colourpicker.enableAndShow();
        this.saveAsLabel.setEnabled(false);
    }

    void colourpickerSetClosed() {
        this.border.setTop(this.colourpicker.top()).setHeight(this.newHeight);
        this.colourpicker.disableAndHide();
    }

    void textInputOn() {
        this.presetNameInputBox.func_146184_c(true);
        this.presetNameInputBox.func_146189_e(true);
        this.presetNameInputBox.func_146195_b(true);
        this.saveAsLabel.setEnabled(true);
    }

    void textInputOff() {
        this.presetNameInputBox.func_146184_c(false);
        this.presetNameInputBox.func_146189_e(false);
        this.presetNameInputBox.func_146195_b(false);
        this.saveAsLabel.setEnabled(false);
    }

    void showPresetFrame() {
        this.cosmeticFrame.enableAndShow();
        this.partframe.disableAndHide();
    }

    void showPartManipFrame() {
        this.cosmeticFrame.disableAndHide();
        this.partframe.enableAndShow();
    }

    public EntityEquipmentSlot getEquipmentSlot() {
        ItemStack selectedItem = this.getSelectedItem().getItem();
        if (!selectedItem.func_190926_b() && selectedItem.func_77973_b() instanceof ItemPowerArmor) {
            return ((ItemPowerArmor)selectedItem.func_77973_b()).field_77881_a;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        ItemStack heldItem = player.func_184592_cb();
        if (!heldItem.func_190926_b() && MuseItemUtils.stackEqualExact((ItemStack)selectedItem, (ItemStack)heldItem)) {
            return EntityEquipmentSlot.OFFHAND;
        }
        return EntityEquipmentSlot.MAINHAND;
    }

    void checkAndFixItem(ClickableItem clickie) {
        ItemStack itemStack;
        NBTTagCompound itemNBT;
        if (clickie != null && (itemNBT = MuseNBTUtils.getMuseItemTag((ItemStack)(itemStack = clickie.getItem()))).func_150297_b("render", 10)) {
            BiMap<String, NBTTagCompound> presetMap = MPSConfig.getCosmeticPresets(itemStack);
            if (presetMap.containsValue((Object)itemNBT.func_74775_l("render"))) {
                String name = (String)presetMap.inverse().get((Object)itemNBT.func_74775_l("render"));
                MPSPackets.sendToServer((IMessage)new MusePacketCosmeticPreset((EntityPlayer)Minecraft.func_71410_x().field_71439_g, clickie.inventorySlot, name));
            } else {
                MPSPackets.sendToServer((IMessage)new MusePacketCosmeticPreset((EntityPlayer)Minecraft.func_71410_x().field_71439_g, clickie.inventorySlot, "Default"));
            }
        }
    }

    public void onGuiClosed() {
        if (this.allowCosmeticPresetCreation && this.isEditing) {
            this.itemSelector.itemButtons.stream().filter(ClickableItem.class::isInstance).map(ClickableItem.class::cast).forEach(clickie -> this.checkAndFixItem((ClickableItem)clickie));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(double mouseX, double mouseY) {
        block5: {
            block4: {
                if (this.usingCosmeticPresets) break block4;
                if (MPSConfig.INSTANCE.allowPowerFistCustomization() || this.itemSelector.getSelectedItem() == null || !(this.getSelectedItem().getItem().func_77973_b() instanceof ItemPowerFist)) break block5;
            }
            if (this.allowCosmeticPresetCreation) {
                this.cosmeticPresetCreator();
                return;
            }
            this.cosmeticPresetsNormal();
            return;
        }
        this.setLegacyMode();
    }

    NBTTagCompound getDefaultPreset(@Nonnull ItemStack itemStack) {
        return MPSConfig.getPresetNBTFor(itemStack, "Default");
    }

    public boolean isValidItem(ClickableItem clickie, EntityEquipmentSlot slot) {
        if (clickie != null) {
            if (clickie.getItem().func_77973_b() instanceof ItemPowerArmor) {
                return clickie.getItem().func_77973_b().isValidArmor(clickie.getItem(), slot, (Entity)Minecraft.func_71410_x().field_71439_g);
            }
            if (clickie.getItem().func_77973_b() instanceof ItemPowerFist && slot.func_188453_a().equals((Object)EntityEquipmentSlot.Type.HAND)) {
                return true;
            }
        }
        return false;
    }

    public ClickableItem getSelectedItem() {
        return this.itemSelector.getSelectedItem();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        block13: {
            block12: {
                if (this.itemSelector.getSelectedItem() == null || this.itemSelector.getSelectedItem().getItem().func_190926_b()) {
                    return false;
                }
                if (this.usingCosmeticPresets) break block12;
                if (MPSConfig.INSTANCE.allowPowerFistCustomization() || this.getSelectedItem() == null || !(this.getSelectedItem().getItem().func_77973_b() instanceof ItemPowerFist)) break block13;
            }
            if (this.allowCosmeticPresetCreation) {
                if (this.isEditing) {
                    if (this.saveButton.containsPoint(mouseX, mouseY)) {
                        if (this.presetNameInputBox.func_146176_q()) {
                            ItemStack itemStack;
                            String name = this.presetNameInputBox.func_146179_b();
                            boolean save = CosmeticPresetSaveLoad.savePreset(name, itemStack = this.getSelectedItem().getItem());
                            if (!save || !this.isValidItem(this.getSelectedItem(), this.getEquipmentSlot())) return true;
                            NBTTagCompound nbt = MPSNBTUtils.getMuseRenderTag(itemStack).func_74737_b();
                            MPSPackets.sendToServer((IMessage)new MusePacketCosmeticPresetUpdate(itemStack.func_77973_b().getRegistryName(), name, nbt));
                            return true;
                        } else {
                            this.textInputOn();
                        }
                        return true;
                    }
                    if (this.resetButton.containsPoint(mouseX, mouseY)) {
                        if (!this.isValidItem(this.getSelectedItem(), this.getEquipmentSlot())) return true;
                        NBTTagCompound nbt = this.getDefaultPreset(this.itemSelector.getSelectedItem().getItem());
                        MPSPackets.sendToServer((IMessage)new MusePacketCosmeticInfo(this.player, this.itemSelector.getSelectedItem().inventorySlot, "render", nbt));
                        return true;
                    }
                    if (!this.loadButton.containsPoint(mouseX, mouseY)) return false;
                    if (this.isValidItem(this.getSelectedItem(), this.getEquipmentSlot())) {
                        MPSPackets.sendToServer((IMessage)new MusePacketCosmeticPreset((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.getSelectedItem().inventorySlot, "Default"));
                    }
                    this.isEditing = false;
                    return true;
                }
                if (this.saveButton.containsPoint(mouseX, mouseY)) {
                    if (!this.isValidItem(this.getSelectedItem(), this.getEquipmentSlot())) return true;
                    this.isEditing = true;
                    NBTTagCompound nbt = MPSNBTUtils.getMuseRenderTag(this.getSelectedItem().getItem(), this.getEquipmentSlot());
                    MPSPackets.sendToServer((IMessage)new MusePacketCosmeticInfo((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.getSelectedItem().inventorySlot, "render", nbt));
                    return true;
                }
                if (!this.resetButton.containsPoint(mouseX, mouseY)) return false;
                if (!this.isValidItem(this.getSelectedItem(), this.getEquipmentSlot())) return true;
                MPSPackets.sendToServer((IMessage)new MusePacketCosmeticPreset((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.getSelectedItem().inventorySlot, "Default"));
                return true;
            }
            if (!this.resetButton.containsPoint(mouseX, mouseY) || !this.isValidItem(this.getSelectedItem(), this.getEquipmentSlot())) return false;
            MPSPackets.sendToServer((IMessage)new MusePacketCosmeticPreset((EntityPlayer)Minecraft.func_71410_x().field_71439_g, this.getSelectedItem().inventorySlot, "Default"));
            return true;
        }
        if (!this.resetButton.containsPoint(mouseX, mouseY) || !this.isValidItem(this.getSelectedItem(), this.getEquipmentSlot())) return false;
        NBTTagCompound nbt = DefaultModelSpec.makeModelPrefs(this.itemSelector.getSelectedItem().getItem());
        MPSPackets.sendToServer((IMessage)new MusePacketCosmeticInfo(this.player, this.itemSelector.getSelectedItem().inventorySlot, "render", nbt));
        return true;
    }

    public void render(double mouseX, double mouseY, float partialTicks) {
        if (this.border instanceof IDrawable) {
            ((IDrawable)this.border).render(mouseX, mouseY, partialTicks);
        }
        this.loadButton.render(mouseX, mouseY, partialTicks);
        this.saveButton.render(mouseX, mouseY, partialTicks);
        this.resetButton.render(mouseX, mouseY, partialTicks);
        this.saveAsLabel.render(mouseX, mouseY, partialTicks);
        this.presetNameInputBox.func_146194_f();
    }

    private static boolean isValidCharacterForName(char typedChar, int keyCode) {
        return keyCode == 14 || keyCode == 12 || keyCode == 147 || Character.isDigit(typedChar) || Character.isLetter(typedChar) || Character.isSpaceChar(typedChar);
    }

    public List<String> getToolTip(double mouseX, double mouseY) {
        return null;
    }

    public void keyTyped(char typedChar, int keyCode) {
        if (this.presetNameInputBox.func_146176_q() && LoadSaveResetSubFrame.isValidCharacterForName(typedChar, keyCode)) {
            this.presetNameInputBox.func_146201_a(typedChar, keyCode);
        }
    }
}

