/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.client.control;

import net.machinemuse.numina.common.capabilities.player.CapabilityPlayerValues;
import net.machinemuse.numina.common.capabilities.player.IPlayerValues;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;

public class PlayerMovementInputWrapper {
    public static PlayerMovementInput get(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            if (player instanceof EntityOtherPlayerMP) {
                return PlayerMovementInputWrapper.fromServer(player);
            }
            return PlayerMovementInputWrapper.fromClient(player);
        }
        return PlayerMovementInputWrapper.fromServer(player);
    }

    static IPlayerValues getCapability(EntityPlayer player) {
        return (IPlayerValues)player.getCapability(CapabilityPlayerValues.PLAYER_VALUES, null);
    }

    static PlayerMovementInput fromServer(EntityPlayer player) {
        boolean jumpKey = false;
        boolean downKey = false;
        IPlayerValues playerCap = PlayerMovementInputWrapper.getCapability(player);
        if (playerCap != null) {
            jumpKey = playerCap.getJumpKeyState();
            downKey = playerCap.getDownKeyState();
        }
        return new PlayerMovementInput(player.field_70702_br, player.field_191988_bg, jumpKey, downKey, player.func_70093_af());
    }

    static PlayerMovementInput fromClient(EntityPlayer player) {
        boolean jumpKey = false;
        boolean downKey = false;
        EntityPlayerSP clientPlayer = (EntityPlayerSP)player;
        IPlayerValues playerCap = PlayerMovementInputWrapper.getCapability(player);
        if (playerCap != null) {
            jumpKey = playerCap.getJumpKeyState();
            downKey = playerCap.getDownKeyState();
        }
        return new PlayerMovementInput(clientPlayer.field_71158_b.field_78902_a, clientPlayer.field_71158_b.field_192832_b, jumpKey, downKey, clientPlayer.field_71158_b.field_78899_d);
    }

    public static class PlayerMovementInput {
        public float moveStrafe;
        public float moveForward;
        public boolean jumpKey;
        public boolean downKey;
        public boolean sneakKey;

        public PlayerMovementInput(float moveStrafe, float moveForward, boolean jumpKey, boolean downKey, boolean sneakKey) {
            this.moveStrafe = Math.signum(moveStrafe);
            this.moveForward = Math.signum(moveForward);
            this.jumpKey = jumpKey;
            this.downKey = downKey;
            this.sneakKey = sneakKey;
        }
    }
}

