/*
 * Decompiled with CFR 0.152.
 */
package org.poly2tri.triangulation.delaunay.sweep;

import java.util.List;
import org.poly2tri.triangulation.TriangulationMode;
import org.poly2tri.triangulation.TriangulationPoint;
import org.poly2tri.triangulation.TriangulationUtil;
import org.poly2tri.triangulation.delaunay.DelaunayTriangle;
import org.poly2tri.triangulation.delaunay.sweep.AdvancingFrontNode;
import org.poly2tri.triangulation.delaunay.sweep.DTSweepConstraint;
import org.poly2tri.triangulation.delaunay.sweep.DTSweepContext;
import org.poly2tri.triangulation.delaunay.sweep.DTSweepDebugContext;
import org.poly2tri.triangulation.delaunay.sweep.PointOnEdgeException;

public class DTSweep {
    private static final double PI_div2 = 1.5707963267948966;
    private static final double PI_3div4 = 2.356194490192345;

    public static void triangulate(DTSweepContext tcx) {
        tcx.createAdvancingFront();
        DTSweep.sweep(tcx);
        if (tcx.getTriangulationMode() == TriangulationMode.POLYGON) {
            DTSweep.finalizationPolygon(tcx);
        } else {
            DTSweep.finalizationConvexHull(tcx);
        }
        tcx.done();
    }

    private static void sweep(DTSweepContext tcx) {
        List<TriangulationPoint> points = tcx.getPoints();
        for (int i = 1; i < points.size(); ++i) {
            TriangulationPoint point = points.get(i);
            AdvancingFrontNode node = DTSweep.pointEvent(tcx, point);
            if (point.hasEdges()) {
                for (DTSweepConstraint e : point.getEdges()) {
                    if (tcx.isDebugEnabled()) {
                        ((DTSweepDebugContext)tcx.getDebugContext()).setActiveConstraint(e);
                    }
                    DTSweep.edgeEvent(tcx, e, node);
                }
            }
            tcx.update(null);
        }
    }

    private static void finalizationConvexHull(DTSweepContext tcx) {
        DelaunayTriangle t2;
        DelaunayTriangle t1;
        AdvancingFrontNode n1 = tcx.aFront.head.next;
        AdvancingFrontNode n2 = n1.next;
        TriangulationPoint first = n1.point;
        DTSweep.turnAdvancingFrontConvex(tcx, n1, n2);
        n1 = tcx.aFront.tail.prev;
        if (n1.triangle.contains(n1.next.point) && n1.triangle.contains(n1.prev.point)) {
            t1 = n1.triangle.neighborAcross(n1.point);
            DTSweep.rotateTrianglePair(n1.triangle, n1.point, t1, t1.oppositePoint(n1.triangle, n1.point));
            tcx.mapTriangleToNodes(n1.triangle);
            tcx.mapTriangleToNodes(t1);
        }
        n1 = tcx.aFront.head.next;
        if (n1.triangle.contains(n1.prev.point) && n1.triangle.contains(n1.next.point)) {
            t1 = n1.triangle.neighborAcross(n1.point);
            DTSweep.rotateTrianglePair(n1.triangle, n1.point, t1, t1.oppositePoint(n1.triangle, n1.point));
            tcx.mapTriangleToNodes(n1.triangle);
            tcx.mapTriangleToNodes(t1);
        }
        first = tcx.aFront.head.point;
        n2 = tcx.aFront.tail.prev;
        t1 = n2.triangle;
        TriangulationPoint p1 = n2.point;
        n2.triangle = null;
        while (true) {
            tcx.removeFromList(t1);
            p1 = t1.pointCCW(p1);
            if (p1 == first) break;
            t2 = t1.neighborCCW(p1);
            t1.clear();
            t1 = t2;
        }
        first = tcx.aFront.head.next.point;
        p1 = t1.pointCW(tcx.aFront.head.point);
        t2 = t1.neighborCW(tcx.aFront.head.point);
        t1.clear();
        t1 = t2;
        while (p1 != first) {
            tcx.removeFromList(t1);
            p1 = t1.pointCCW(p1);
            t2 = t1.neighborCCW(p1);
            t1.clear();
            t1 = t2;
        }
        tcx.aFront.head = tcx.aFront.head.next;
        tcx.aFront.head.prev = null;
        tcx.aFront.tail = tcx.aFront.tail.prev;
        tcx.aFront.tail.next = null;
        tcx.finalizeTriangulation();
    }

    private static void turnAdvancingFrontConvex(DTSweepContext tcx, AdvancingFrontNode b, AdvancingFrontNode c) {
        AdvancingFrontNode first = b;
        while (c != tcx.aFront.tail) {
            if (tcx.isDebugEnabled()) {
                ((DTSweepDebugContext)tcx.getDebugContext()).setActiveNode(c);
            }
            if (TriangulationUtil.orient2d(b.point, c.point, c.next.point) == TriangulationUtil.Orientation.CCW) {
                DTSweep.fill(tcx, c);
                c = c.next;
                continue;
            }
            if (b != first && TriangulationUtil.orient2d(b.prev.point, b.point, c.point) == TriangulationUtil.Orientation.CCW) {
                DTSweep.fill(tcx, b);
                b = b.prev;
                continue;
            }
            b = c;
            c = c.next;
        }
    }

    private static void finalizationPolygon(DTSweepContext tcx) {
        DelaunayTriangle t = tcx.aFront.head.next.triangle;
        TriangulationPoint p = tcx.aFront.head.next.point;
        while (!t.getConstrainedEdgeCW(p)) {
            t = t.neighborCCW(p);
        }
        tcx.meshClean(t);
    }

    private static AdvancingFrontNode pointEvent(DTSweepContext tcx, TriangulationPoint point) {
        AdvancingFrontNode node = tcx.locateNode(point);
        if (tcx.isDebugEnabled()) {
            ((DTSweepDebugContext)tcx.getDebugContext()).setActiveNode(node);
        }
        AdvancingFrontNode newNode = DTSweep.newFrontTriangle(tcx, point, node);
        if (point.getX() <= node.point.getX() + 1.0E-12) {
            DTSweep.fill(tcx, node);
        }
        tcx.addNode(newNode);
        DTSweep.fillAdvancingFront(tcx, newNode);
        return newNode;
    }

    private static AdvancingFrontNode newFrontTriangle(DTSweepContext tcx, TriangulationPoint point, AdvancingFrontNode node) {
        DelaunayTriangle triangle = new DelaunayTriangle(point, node.point, node.next.point);
        triangle.markNeighbor(node.triangle);
        tcx.addToList(triangle);
        AdvancingFrontNode newNode = new AdvancingFrontNode(point);
        newNode.next = node.next;
        newNode.prev = node;
        node.next.prev = newNode;
        node.next = newNode;
        tcx.addNode(newNode);
        if (tcx.isDebugEnabled()) {
            ((DTSweepDebugContext)tcx.getDebugContext()).setActiveNode(newNode);
        }
        if (!DTSweep.legalize(tcx, triangle)) {
            tcx.mapTriangleToNodes(triangle);
        }
        return newNode;
    }

    private static void edgeEvent(DTSweepContext tcx, DTSweepConstraint edge, AdvancingFrontNode node) {
        try {
            tcx.edgeEvent.constrainedEdge = edge;
            boolean bl = tcx.edgeEvent.right = edge.p.getX() > edge.q.getX();
            if (tcx.isDebugEnabled()) {
                ((DTSweepDebugContext)tcx.getDebugContext()).setPrimaryTriangle(node.triangle);
            }
            if (DTSweep.isEdgeSideOfTriangle(node.triangle, edge.p, edge.q)) {
                return;
            }
            DTSweep.fillEdgeEvent(tcx, edge, node);
            DTSweep.edgeEvent(tcx, edge.p, edge.q, node.triangle, edge.q);
        }
        catch (PointOnEdgeException e) {
            System.out.println("Warning: Skipping edge: " + e.getMessage());
        }
    }

    private static void fillEdgeEvent(DTSweepContext tcx, DTSweepConstraint edge, AdvancingFrontNode node) {
        if (tcx.edgeEvent.right) {
            DTSweep.fillRightAboveEdgeEvent(tcx, edge, node);
        } else {
            DTSweep.fillLeftAboveEdgeEvent(tcx, edge, node);
        }
    }

    private static void fillRightConcaveEdgeEvent(DTSweepContext tcx, DTSweepConstraint edge, AdvancingFrontNode node) {
        DTSweep.fill(tcx, node.next);
        if (node.next.point != edge.p && TriangulationUtil.orient2d(edge.q, node.next.point, edge.p) == TriangulationUtil.Orientation.CCW && TriangulationUtil.orient2d(node.point, node.next.point, node.next.next.point) == TriangulationUtil.Orientation.CCW) {
            DTSweep.fillRightConcaveEdgeEvent(tcx, edge, node);
        }
    }

    private static void fillRightConvexEdgeEvent(DTSweepContext tcx, DTSweepConstraint edge, AdvancingFrontNode node) {
        if (TriangulationUtil.orient2d(node.next.point, node.next.next.point, node.next.next.next.point) == TriangulationUtil.Orientation.CCW) {
            DTSweep.fillRightConcaveEdgeEvent(tcx, edge, node.next);
        } else if (TriangulationUtil.orient2d(edge.q, node.next.next.point, edge.p) == TriangulationUtil.Orientation.CCW) {
            DTSweep.fillRightConvexEdgeEvent(tcx, edge, node.next);
        }
    }

    private static void fillRightBelowEdgeEvent(DTSweepContext tcx, DTSweepConstraint edge, AdvancingFrontNode node) {
        if (tcx.isDebugEnabled()) {
            ((DTSweepDebugContext)tcx.getDebugContext()).setActiveNode(node);
        }
        if (node.point.getX() < edge.p.getX()) {
            if (TriangulationUtil.orient2d(node.point, node.next.point, node.next.next.point) == TriangulationUtil.Orientation.CCW) {
                DTSweep.fillRightConcaveEdgeEvent(tcx, edge, node);
            } else {
                DTSweep.fillRightConvexEdgeEvent(tcx, edge, node);
                DTSweep.fillRightBelowEdgeEvent(tcx, edge, node);
            }
        }
    }

    private static void fillRightAboveEdgeEvent(DTSweepContext tcx, DTSweepConstraint edge, AdvancingFrontNode node) {
        while (node.next.point.getX() < edge.p.getX()) {
            TriangulationUtil.Orientation o1;
            if (tcx.isDebugEnabled()) {
                ((DTSweepDebugContext)tcx.getDebugContext()).setActiveNode(node);
            }
            if ((o1 = TriangulationUtil.orient2d(edge.q, node.next.point, edge.p)) == TriangulationUtil.Orientation.CCW) {
                DTSweep.fillRightBelowEdgeEvent(tcx, edge, node);
                continue;
            }
            node = node.next;
        }
    }

    private static void fillLeftConvexEdgeEvent(DTSweepContext tcx, DTSweepConstraint edge, AdvancingFrontNode node) {
        if (TriangulationUtil.orient2d(node.prev.point, node.prev.prev.point, node.prev.prev.prev.point) == TriangulationUtil.Orientation.CW) {
            DTSweep.fillLeftConcaveEdgeEvent(tcx, edge, node.prev);
        } else if (TriangulationUtil.orient2d(edge.q, node.prev.prev.point, edge.p) == TriangulationUtil.Orientation.CW) {
            DTSweep.fillLeftConvexEdgeEvent(tcx, edge, node.prev);
        }
    }

    private static void fillLeftConcaveEdgeEvent(DTSweepContext tcx, DTSweepConstraint edge, AdvancingFrontNode node) {
        DTSweep.fill(tcx, node.prev);
        if (node.prev.point != edge.p && TriangulationUtil.orient2d(edge.q, node.prev.point, edge.p) == TriangulationUtil.Orientation.CW && TriangulationUtil.orient2d(node.point, node.prev.point, node.prev.prev.point) == TriangulationUtil.Orientation.CW) {
            DTSweep.fillLeftConcaveEdgeEvent(tcx, edge, node);
        }
    }

    private static void fillLeftBelowEdgeEvent(DTSweepContext tcx, DTSweepConstraint edge, AdvancingFrontNode node) {
        if (tcx.isDebugEnabled()) {
            ((DTSweepDebugContext)tcx.getDebugContext()).setActiveNode(node);
        }
        if (node.point.getX() > edge.p.getX()) {
            if (TriangulationUtil.orient2d(node.point, node.prev.point, node.prev.prev.point) == TriangulationUtil.Orientation.CW) {
                DTSweep.fillLeftConcaveEdgeEvent(tcx, edge, node);
            } else {
                DTSweep.fillLeftConvexEdgeEvent(tcx, edge, node);
                DTSweep.fillLeftBelowEdgeEvent(tcx, edge, node);
            }
        }
    }

    private static void fillLeftAboveEdgeEvent(DTSweepContext tcx, DTSweepConstraint edge, AdvancingFrontNode node) {
        while (node.prev.point.getX() > edge.p.getX()) {
            TriangulationUtil.Orientation o1;
            if (tcx.isDebugEnabled()) {
                ((DTSweepDebugContext)tcx.getDebugContext()).setActiveNode(node);
            }
            if ((o1 = TriangulationUtil.orient2d(edge.q, node.prev.point, edge.p)) == TriangulationUtil.Orientation.CW) {
                DTSweep.fillLeftBelowEdgeEvent(tcx, edge, node);
                continue;
            }
            node = node.prev;
        }
    }

    private static boolean isEdgeSideOfTriangle(DelaunayTriangle triangle, TriangulationPoint ep, TriangulationPoint eq) {
        int index = triangle.edgeIndex(ep, eq);
        if (index != -1) {
            triangle.markConstrainedEdge(index);
            triangle = triangle.neighbors[index];
            if (triangle != null) {
                triangle.markConstrainedEdge(ep, eq);
            }
            return true;
        }
        return false;
    }

    private static void edgeEvent(DTSweepContext tcx, TriangulationPoint ep, TriangulationPoint eq, DelaunayTriangle triangle, TriangulationPoint point) {
        if (tcx.isDebugEnabled()) {
            ((DTSweepDebugContext)tcx.getDebugContext()).setPrimaryTriangle(triangle);
        }
        if (DTSweep.isEdgeSideOfTriangle(triangle, ep, eq)) {
            return;
        }
        TriangulationPoint p1 = triangle.pointCCW(point);
        TriangulationUtil.Orientation o1 = TriangulationUtil.orient2d(eq, p1, ep);
        if (o1 == TriangulationUtil.Orientation.Collinear) {
            if (!triangle.contains(eq, p1)) {
                throw new PointOnEdgeException("EdgeEvent - Point on constrained edge not supported yet");
            }
            triangle.markConstrainedEdge(eq, p1);
            tcx.edgeEvent.constrainedEdge.q = p1;
            triangle = triangle.neighborAcross(point);
            DTSweep.edgeEvent(tcx, ep, p1, triangle, p1);
            if (tcx.isDebugEnabled()) {
                System.out.println("EdgeEvent - Point on constrained edge");
            }
            return;
        }
        TriangulationPoint p2 = triangle.pointCW(point);
        TriangulationUtil.Orientation o2 = TriangulationUtil.orient2d(eq, p2, ep);
        if (o2 == TriangulationUtil.Orientation.Collinear) {
            if (!triangle.contains(eq, p2)) {
                throw new PointOnEdgeException("EdgeEvent - Point on constrained edge not supported yet");
            }
            triangle.markConstrainedEdge(eq, p2);
            tcx.edgeEvent.constrainedEdge.q = p2;
            triangle = triangle.neighborAcross(point);
            DTSweep.edgeEvent(tcx, ep, p2, triangle, p2);
            if (tcx.isDebugEnabled()) {
                System.out.println("EdgeEvent - Point on constrained edge");
            }
            return;
        }
        if (o1 == o2) {
            triangle = o1 == TriangulationUtil.Orientation.CW ? triangle.neighborCCW(point) : triangle.neighborCW(point);
            DTSweep.edgeEvent(tcx, ep, eq, triangle, point);
        } else {
            DTSweep.flipEdgeEvent(tcx, ep, eq, triangle, point);
        }
    }

    private static void flipEdgeEvent(DTSweepContext tcx, TriangulationPoint ep, TriangulationPoint eq, DelaunayTriangle t, TriangulationPoint p) {
        boolean inScanArea;
        DelaunayTriangle ot = t.neighborAcross(p);
        TriangulationPoint op = ot.oppositePoint(t, p);
        if (ot == null) {
            throw new RuntimeException("[BUG:FIXME] FLIP failed due to missing triangle");
        }
        if (t.getConstrainedEdgeAcross(p)) {
            throw new RuntimeException("Intersecting Constraints");
        }
        if (tcx.isDebugEnabled()) {
            ((DTSweepDebugContext)tcx.getDebugContext()).setPrimaryTriangle(t);
            ((DTSweepDebugContext)tcx.getDebugContext()).setSecondaryTriangle(ot);
        }
        if (inScanArea = TriangulationUtil.inScanArea(p, t.pointCCW(p), t.pointCW(p), op)) {
            DTSweep.rotateTrianglePair(t, p, ot, op);
            tcx.mapTriangleToNodes(t);
            tcx.mapTriangleToNodes(ot);
            if (p == eq && op == ep) {
                if (eq == tcx.edgeEvent.constrainedEdge.q && ep == tcx.edgeEvent.constrainedEdge.p) {
                    if (tcx.isDebugEnabled()) {
                        System.out.println("[FLIP] - constrained edge done");
                    }
                    t.markConstrainedEdge(ep, eq);
                    ot.markConstrainedEdge(ep, eq);
                    DTSweep.legalize(tcx, t);
                    DTSweep.legalize(tcx, ot);
                } else if (tcx.isDebugEnabled()) {
                    System.out.println("[FLIP] - subedge done");
                }
            } else {
                if (tcx.isDebugEnabled()) {
                    System.out.println("[FLIP] - flipping and continuing with triangle still crossing edge");
                }
                TriangulationUtil.Orientation o = TriangulationUtil.orient2d(eq, op, ep);
                t = DTSweep.nextFlipTriangle(tcx, o, t, ot, p, op);
                DTSweep.flipEdgeEvent(tcx, ep, eq, t, p);
            }
        } else {
            TriangulationPoint newP = DTSweep.nextFlipPoint(ep, eq, ot, op);
            DTSweep.flipScanEdgeEvent(tcx, ep, eq, t, ot, newP);
            DTSweep.edgeEvent(tcx, ep, eq, t, p);
        }
    }

    private static TriangulationPoint nextFlipPoint(TriangulationPoint ep, TriangulationPoint eq, DelaunayTriangle ot, TriangulationPoint op) {
        TriangulationUtil.Orientation o2d = TriangulationUtil.orient2d(eq, op, ep);
        if (o2d == TriangulationUtil.Orientation.CW) {
            return ot.pointCCW(op);
        }
        if (o2d == TriangulationUtil.Orientation.CCW) {
            return ot.pointCW(op);
        }
        throw new PointOnEdgeException("Point on constrained edge not supported yet");
    }

    private static DelaunayTriangle nextFlipTriangle(DTSweepContext tcx, TriangulationUtil.Orientation o, DelaunayTriangle t, DelaunayTriangle ot, TriangulationPoint p, TriangulationPoint op) {
        if (o == TriangulationUtil.Orientation.CCW) {
            int edgeIndex = ot.edgeIndex(p, op);
            ot.dEdge[edgeIndex] = true;
            DTSweep.legalize(tcx, ot);
            ot.clearDelunayEdges();
            return t;
        }
        int edgeIndex = t.edgeIndex(p, op);
        t.dEdge[edgeIndex] = true;
        DTSweep.legalize(tcx, t);
        t.clearDelunayEdges();
        return ot;
    }

    private static void flipScanEdgeEvent(DTSweepContext tcx, TriangulationPoint ep, TriangulationPoint eq, DelaunayTriangle flipTriangle, DelaunayTriangle t, TriangulationPoint p) {
        boolean inScanArea;
        DelaunayTriangle ot = t.neighborAcross(p);
        TriangulationPoint op = ot.oppositePoint(t, p);
        if (ot == null) {
            throw new RuntimeException("[BUG:FIXME] FLIP failed due to missing triangle");
        }
        if (tcx.isDebugEnabled()) {
            System.out.println("[FLIP:SCAN] - scan next point");
            ((DTSweepDebugContext)tcx.getDebugContext()).setPrimaryTriangle(t);
            ((DTSweepDebugContext)tcx.getDebugContext()).setSecondaryTriangle(ot);
        }
        if (inScanArea = TriangulationUtil.inScanArea(eq, flipTriangle.pointCCW(eq), flipTriangle.pointCW(eq), op)) {
            DTSweep.flipEdgeEvent(tcx, eq, op, ot, op);
        } else {
            TriangulationPoint newP = DTSweep.nextFlipPoint(ep, eq, ot, op);
            DTSweep.flipScanEdgeEvent(tcx, ep, eq, flipTriangle, ot, newP);
        }
    }

    private static void fillAdvancingFront(DTSweepContext tcx, AdvancingFrontNode n) {
        double angle;
        AdvancingFrontNode node = n.next;
        while (node.hasNext() && !DTSweep.isLargeHole(node)) {
            DTSweep.fill(tcx, node);
            node = node.next;
        }
        node = n.prev;
        while (node.hasPrevious() && !DTSweep.isLargeHole(node)) {
            DTSweep.fill(tcx, node);
            node = node.prev;
        }
        if (n.hasNext() && n.next.hasNext() && (angle = DTSweep.basinAngle(n)) < 2.356194490192345) {
            DTSweep.fillBasin(tcx, n);
        }
    }

    private static boolean isLargeHole(AdvancingFrontNode node) {
        double angle = DTSweep.angle(node.point, node.next.point, node.prev.point);
        return angle > 1.5707963267948966 || angle < 0.0;
    }

    private static void fillBasin(DTSweepContext tcx, AdvancingFrontNode node) {
        tcx.basin.leftNode = TriangulationUtil.orient2d(node.point, node.next.point, node.next.next.point) == TriangulationUtil.Orientation.CCW ? node : node.next;
        tcx.basin.bottomNode = tcx.basin.leftNode;
        while (tcx.basin.bottomNode.hasNext() && tcx.basin.bottomNode.point.getY() >= tcx.basin.bottomNode.next.point.getY()) {
            tcx.basin.bottomNode = tcx.basin.bottomNode.next;
        }
        if (tcx.basin.bottomNode == tcx.basin.leftNode) {
            return;
        }
        tcx.basin.rightNode = tcx.basin.bottomNode;
        while (tcx.basin.rightNode.hasNext() && tcx.basin.rightNode.point.getY() < tcx.basin.rightNode.next.point.getY()) {
            tcx.basin.rightNode = tcx.basin.rightNode.next;
        }
        if (tcx.basin.rightNode == tcx.basin.bottomNode) {
            return;
        }
        tcx.basin.width = tcx.basin.rightNode.getPoint().getX() - tcx.basin.leftNode.getPoint().getX();
        tcx.basin.leftHighest = tcx.basin.leftNode.getPoint().getY() > tcx.basin.rightNode.getPoint().getY();
        DTSweep.fillBasinReq(tcx, tcx.basin.bottomNode);
    }

    private static void fillBasinReq(DTSweepContext tcx, AdvancingFrontNode node) {
        if (DTSweep.isShallow(tcx, node)) {
            return;
        }
        DTSweep.fill(tcx, node);
        if (node.prev == tcx.basin.leftNode && node.next == tcx.basin.rightNode) {
            return;
        }
        if (node.prev == tcx.basin.leftNode) {
            TriangulationUtil.Orientation o = TriangulationUtil.orient2d(node.point, node.next.point, node.next.next.point);
            if (o == TriangulationUtil.Orientation.CW) {
                return;
            }
            node = node.next;
        } else if (node.next == tcx.basin.rightNode) {
            TriangulationUtil.Orientation o = TriangulationUtil.orient2d(node.point, node.prev.point, node.prev.prev.point);
            if (o == TriangulationUtil.Orientation.CCW) {
                return;
            }
            node = node.prev;
        } else {
            node = node.prev.point.getY() < node.next.point.getY() ? node.prev : node.next;
        }
        DTSweep.fillBasinReq(tcx, node);
    }

    private static boolean isShallow(DTSweepContext tcx, AdvancingFrontNode node) {
        double height = tcx.basin.leftHighest ? tcx.basin.leftNode.getPoint().getY() - node.getPoint().getY() : tcx.basin.rightNode.getPoint().getY() - node.getPoint().getY();
        return tcx.basin.width > height;
    }

    private static double angle(TriangulationPoint p, TriangulationPoint a, TriangulationPoint b) {
        double px = p.getX();
        double py = p.getY();
        double ax = a.getX() - px;
        double ay = a.getY() - py;
        double bx = b.getX() - px;
        double by = b.getY() - py;
        return Math.atan2(ax * by - ay * bx, ax * bx + ay * by);
    }

    private static double basinAngle(AdvancingFrontNode node) {
        double ax = node.point.getX() - node.next.next.point.getX();
        double ay = node.point.getY() - node.next.next.point.getY();
        return Math.atan2(ay, ax);
    }

    private static void fill(DTSweepContext tcx, AdvancingFrontNode node) {
        DelaunayTriangle triangle = new DelaunayTriangle(node.prev.point, node.point, node.next.point);
        triangle.markNeighbor(node.prev.triangle);
        triangle.markNeighbor(node.triangle);
        tcx.addToList(triangle);
        node.prev.next = node.next;
        node.next.prev = node.prev;
        tcx.removeNode(node);
        if (!DTSweep.legalize(tcx, triangle)) {
            tcx.mapTriangleToNodes(triangle);
        }
    }

    private static boolean legalize(DTSweepContext tcx, DelaunayTriangle t) {
        for (int i = 0; i < 3; ++i) {
            boolean notLegalized;
            DelaunayTriangle ot;
            if (t.dEdge[i] || (ot = t.neighbors[i]) == null) continue;
            TriangulationPoint p = t.points[i];
            TriangulationPoint op = ot.oppositePoint(t, p);
            int oi = ot.index(op);
            if (ot.cEdge[oi] || ot.dEdge[oi]) {
                t.cEdge[i] = ot.cEdge[oi];
                continue;
            }
            boolean inside = TriangulationUtil.smartIncircle(p, t.pointCCW(p), t.pointCW(p), op);
            if (!inside) continue;
            t.dEdge[i] = true;
            ot.dEdge[oi] = true;
            DTSweep.rotateTrianglePair(t, p, ot, op);
            boolean bl = notLegalized = !DTSweep.legalize(tcx, t);
            if (notLegalized) {
                tcx.mapTriangleToNodes(t);
            }
            boolean bl2 = notLegalized = !DTSweep.legalize(tcx, ot);
            if (notLegalized) {
                tcx.mapTriangleToNodes(ot);
            }
            t.dEdge[i] = false;
            ot.dEdge[oi] = false;
            return true;
        }
        return false;
    }

    private static void rotateTrianglePair(DelaunayTriangle t, TriangulationPoint p, DelaunayTriangle ot, TriangulationPoint op) {
        DelaunayTriangle n1 = t.neighborCCW(p);
        DelaunayTriangle n2 = t.neighborCW(p);
        DelaunayTriangle n3 = ot.neighborCCW(op);
        DelaunayTriangle n4 = ot.neighborCW(op);
        boolean ce1 = t.getConstrainedEdgeCCW(p);
        boolean ce2 = t.getConstrainedEdgeCW(p);
        boolean ce3 = ot.getConstrainedEdgeCCW(op);
        boolean ce4 = ot.getConstrainedEdgeCW(op);
        boolean de1 = t.getDelunayEdgeCCW(p);
        boolean de2 = t.getDelunayEdgeCW(p);
        boolean de3 = ot.getDelunayEdgeCCW(op);
        boolean de4 = ot.getDelunayEdgeCW(op);
        t.legalize(p, op);
        ot.legalize(op, p);
        ot.setDelunayEdgeCCW(p, de1);
        t.setDelunayEdgeCW(p, de2);
        t.setDelunayEdgeCCW(op, de3);
        ot.setDelunayEdgeCW(op, de4);
        ot.setConstrainedEdgeCCW(p, ce1);
        t.setConstrainedEdgeCW(p, ce2);
        t.setConstrainedEdgeCCW(op, ce3);
        ot.setConstrainedEdgeCW(op, ce4);
        t.clearNeighbors();
        ot.clearNeighbors();
        if (n1 != null) {
            ot.markNeighbor(n1);
        }
        if (n2 != null) {
            t.markNeighbor(n2);
        }
        if (n3 != null) {
            t.markNeighbor(n3);
        }
        if (n4 != null) {
            ot.markNeighbor(n4);
        }
        t.markNeighbor(ot);
    }
}

