/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph.specifics;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.EdgeSetFactory;
import org.jgrapht.graph.specifics.ArrayUnenforcedSetEdgeSetFactory;
import org.jgrapht.graph.specifics.DirectedEdgeContainer;
import org.jgrapht.graph.specifics.DirectedSpecifics;
import org.jgrapht.util.ArrayUnenforcedSet;

public class FastLookupDirectedSpecifics<V, E>
extends DirectedSpecifics<V, E> {
    private static final long serialVersionUID = 4089085208843722263L;
    protected Map<Pair<V, V>, ArrayUnenforcedSet<E>> touchingVerticesToEdgeMap = new HashMap<Pair<V, V>, ArrayUnenforcedSet<E>>();

    public FastLookupDirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph) {
        this(abstractBaseGraph, new LinkedHashMap(), new ArrayUnenforcedSetEdgeSetFactory());
    }

    public FastLookupDirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph, Map<V, DirectedEdgeContainer<V, E>> vertexMap) {
        this(abstractBaseGraph, vertexMap, new ArrayUnenforcedSetEdgeSetFactory());
    }

    public FastLookupDirectedSpecifics(AbstractBaseGraph<V, E> abstractBaseGraph, Map<V, DirectedEdgeContainer<V, E>> vertexMap, EdgeSetFactory<V, E> edgeSetFactory) {
        super(abstractBaseGraph, vertexMap, edgeSetFactory);
    }

    @Override
    public Set<E> getAllEdges(V sourceVertex, V targetVertex) {
        if (this.abstractBaseGraph.containsVertex(sourceVertex) && this.abstractBaseGraph.containsVertex(targetVertex)) {
            Set edges = this.touchingVerticesToEdgeMap.get(new Pair<V, V>(sourceVertex, targetVertex));
            return edges == null ? Collections.emptySet() : new ArrayUnenforcedSet(edges);
        }
        return null;
    }

    @Override
    public E getEdge(V sourceVertex, V targetVertex) {
        List edges = this.touchingVerticesToEdgeMap.get(new Pair<V, V>(sourceVertex, targetVertex));
        if (edges == null || edges.isEmpty()) {
            return null;
        }
        return edges.get(0);
    }

    @Override
    public void addEdgeToTouchingVertices(E e) {
        Object source = this.abstractBaseGraph.getEdgeSource(e);
        Object target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).addOutgoingEdge(e);
        this.getEdgeContainer(target).addIncomingEdge(e);
        Pair vertexPair = new Pair(source, target);
        ArrayUnenforcedSet<E> edgeSet = this.touchingVerticesToEdgeMap.get(vertexPair);
        if (edgeSet != null) {
            edgeSet.add(e);
        } else {
            edgeSet = new ArrayUnenforcedSet();
            edgeSet.add(e);
            this.touchingVerticesToEdgeMap.put(vertexPair, edgeSet);
        }
    }

    @Override
    public void removeEdgeFromTouchingVertices(E e) {
        Object source = this.abstractBaseGraph.getEdgeSource(e);
        Object target = this.abstractBaseGraph.getEdgeTarget(e);
        this.getEdgeContainer(source).removeOutgoingEdge(e);
        this.getEdgeContainer(target).removeIncomingEdge(e);
        Pair vertexPair = new Pair(source, target);
        ArrayUnenforcedSet<E> edgeSet = this.touchingVerticesToEdgeMap.get(vertexPair);
        if (edgeSet != null) {
            edgeSet.remove(e);
            if (edgeSet.isEmpty()) {
                this.touchingVerticesToEdgeMap.remove(vertexPair);
            }
        }
    }
}

