/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.vertexcover;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.alg.interfaces.MinimumVertexCoverAlgorithm;
import org.jgrapht.alg.interfaces.MinimumWeightedVertexCoverAlgorithm;
import org.jgrapht.alg.vertexcover.util.RatioVertex;

public class ClarksonTwoApproxVCImpl<V, E>
implements MinimumWeightedVertexCoverAlgorithm<V, E> {
    private static int vertexCounter = 0;

    @Override
    public MinimumVertexCoverAlgorithm.VertexCover<V> getVertexCover(Graph<V, E> graph, Map<V, Double> vertexWeightMap) {
        GraphTests.requireUndirected(graph);
        LinkedHashSet cover = new LinkedHashSet();
        double weight = 0.0;
        HashMap vertexEncapsulationMap = new HashMap();
        graph.vertexSet().stream().filter(v -> graph.degreeOf(v) > 0).forEach(v -> vertexEncapsulationMap.put(v, new RatioVertex<Object>(vertexCounter++, v, (Double)vertexWeightMap.get(v))));
        for (E e : graph.edgeSet()) {
            V u = graph.getEdgeSource(e);
            RatioVertex ux2 = (RatioVertex)vertexEncapsulationMap.get(u);
            V v2 = graph.getEdgeTarget(e);
            RatioVertex vx = (RatioVertex)vertexEncapsulationMap.get(v2);
            ux2.addNeighbor(vx);
            vx.addNeighbor(ux2);
            assert (ux2.neighbors.get(vx).equals(vx.neighbors.get(ux2))) : " in an undirected graph, if vx is a neighbor of ux, then ux must be a neighbor of vx";
        }
        TreeSet<Object> workingGraph = new TreeSet<Object>();
        workingGraph.addAll(vertexEncapsulationMap.values());
        assert (workingGraph.size() == vertexEncapsulationMap.size()) : "vertices in vertexEncapsulationMap: " + graph.vertexSet().size() + "vertices in working graph: " + workingGraph.size();
        while (!workingGraph.isEmpty()) {
            RatioVertex vx = (RatioVertex)workingGraph.pollFirst();
            assert (workingGraph.parallelStream().allMatch(ux -> vx.getRatio() <= ux.getRatio())) : "vx does not have the smallest ratio among all elements. VX: " + vx + " WorkingGraph: " + workingGraph;
            double ratio = vx.getRatio();
            for (RatioVertex nx : vx.neighbors.keySet()) {
                if (nx == vx) continue;
                workingGraph.remove(nx);
                nx.weight -= ratio * (double)vx.neighbors.get(nx).intValue();
                nx.removeNeighbor(vx);
                if (nx.getDegree() <= 0) continue;
                workingGraph.add(nx);
            }
            cover.add(vx.v);
            weight += vertexWeightMap.get(vx.v).doubleValue();
            assert (!workingGraph.parallelStream().anyMatch(ux -> ux.ID == vx.ID)) : "vx should no longer exist in the working graph";
        }
        return new MinimumVertexCoverAlgorithm.VertexCoverImpl(cover, weight);
    }
}

