/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.BaseShortestPathAlgorithm;
import org.jgrapht.graph.GraphWalk;
import org.jgrapht.util.TypeUtil;

public class FloydWarshallShortestPaths<V, E>
extends BaseShortestPathAlgorithm<V, E> {
    private final List<V> vertices;
    private final Map<V, Integer> vertexIndices;
    private double diameter = Double.NaN;
    private double[][] d = null;
    private Object[][] backtrace = null;
    private Object[][] lastHopMatrix = null;

    public FloydWarshallShortestPaths(Graph<V, E> graph) {
        super(graph);
        this.vertices = new ArrayList<V>(graph.vertexSet());
        this.vertexIndices = new HashMap<V, Integer>(this.vertices.size());
        int i = 0;
        for (V vertex : this.vertices) {
            this.vertexIndices.put((Integer)vertex, i++);
        }
    }

    public int getShortestPathsCount() {
        this.lazyCalculateMatrix();
        int n = this.vertices.size();
        int nShortestPaths = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i == j || !Double.isFinite(this.d[i][j])) continue;
                ++nShortestPaths;
            }
        }
        return nShortestPaths;
    }

    @Deprecated
    public double getDiameter() {
        this.lazyCalculateMatrix();
        if (!Double.isNaN(this.diameter)) {
            return this.diameter;
        }
        int n = this.vertices.size();
        if (n > 0) {
            this.diameter = 0.0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    this.diameter = Double.max(this.diameter, this.d[i][j]);
                }
            }
        }
        return this.diameter;
    }

    @Override
    public GraphPath<V, E> getPath(V a, V b) {
        if (!this.graph.containsVertex(a)) {
            throw new IllegalArgumentException("Graph must contain the source vertex!");
        }
        if (!this.graph.containsVertex(b)) {
            throw new IllegalArgumentException("Graph must contain the sink vertex!");
        }
        this.lazyCalculateMatrix();
        int v_a = this.vertexIndices.get(a);
        int v_b = this.vertexIndices.get(b);
        if (this.backtrace[v_a][v_b] == null) {
            return this.createEmptyPath(a, b);
        }
        ArrayList edges = new ArrayList();
        V u = a;
        while (!u.equals(b)) {
            int v_u = this.vertexIndices.get(u);
            Object e = TypeUtil.uncheckedCast(this.backtrace[v_u][v_b], null);
            edges.add(e);
            u = Graphs.getOppositeVertex(this.graph, e, u);
        }
        return new GraphWalk(this.graph, a, b, null, edges, this.d[v_a][v_b]);
    }

    @Override
    public double getPathWeight(V source, V sink) {
        if (!this.graph.containsVertex(source)) {
            throw new IllegalArgumentException("Graph must contain the source vertex!");
        }
        if (!this.graph.containsVertex(sink)) {
            throw new IllegalArgumentException("Graph must contain the sink vertex!");
        }
        this.lazyCalculateMatrix();
        return this.d[this.vertexIndices.get(source)][this.vertexIndices.get(sink)];
    }

    @Override
    public ShortestPathAlgorithm.SingleSourcePaths<V, E> getPaths(V source) {
        return new FloydWarshallSingleSourcePaths(source);
    }

    public V getFirstHop(V a, V b) {
        this.lazyCalculateMatrix();
        int v_a = this.vertexIndices.get(a);
        int v_b = this.vertexIndices.get(b);
        if (this.backtrace[v_a][v_b] == null) {
            return null;
        }
        Object e = TypeUtil.uncheckedCast(this.backtrace[v_a][v_b], null);
        return Graphs.getOppositeVertex(this.graph, e, a);
    }

    public V getLastHop(V a, V b) {
        this.lazyCalculateMatrix();
        int v_a = this.vertexIndices.get(a);
        int v_b = this.vertexIndices.get(b);
        if (this.backtrace[v_a][v_b] == null) {
            return null;
        }
        this.populateLastHopMatrix();
        Object e = TypeUtil.uncheckedCast(this.lastHopMatrix[v_a][v_b], null);
        return Graphs.getOppositeVertex(this.graph, e, b);
    }

    private void lazyCalculateMatrix() {
        int i;
        if (this.d != null) {
            return;
        }
        int n = this.vertices.size();
        this.backtrace = new Object[n][n];
        this.d = new double[n][n];
        for (i = 0; i < n; ++i) {
            Arrays.fill(this.d[i], Double.POSITIVE_INFINITY);
        }
        for (i = 0; i < n; ++i) {
            this.d[i][i] = 0.0;
        }
        if (this.graph.getType().isUndirected()) {
            for (Object edge : this.graph.edgeSet()) {
                Object target;
                Object source = this.graph.getEdgeSource(edge);
                if (source.equals(target = this.graph.getEdgeTarget(edge))) continue;
                int v_1 = this.vertexIndices.get(source);
                int v_2 = this.vertexIndices.get(target);
                double edgeWeight = this.graph.getEdgeWeight(edge);
                if (Double.compare(edgeWeight, this.d[v_1][v_2]) >= 0) continue;
                double d = edgeWeight;
                this.d[v_2][v_1] = d;
                this.d[v_1][v_2] = d;
                this.backtrace[v_1][v_2] = edge;
                this.backtrace[v_2][v_1] = edge;
            }
        } else {
            for (Object v1 : this.graph.vertexSet()) {
                int v_1 = this.vertexIndices.get(v1);
                for (Object e : this.graph.outgoingEdgesOf(v1)) {
                    Object v2 = Graphs.getOppositeVertex(this.graph, e, v1);
                    if (v1.equals(v2)) continue;
                    int v_2 = this.vertexIndices.get(v2);
                    double edgeWeight = this.graph.getEdgeWeight(e);
                    if (Double.compare(edgeWeight, this.d[v_1][v_2]) >= 0) continue;
                    this.d[v_1][v_2] = edgeWeight;
                    this.backtrace[v_1][v_2] = e;
                }
            }
        }
        for (int k = 0; k < n; ++k) {
            for (int i2 = 0; i2 < n; ++i2) {
                for (int j = 0; j < n; ++j) {
                    double ik_kj = this.d[i2][k] + this.d[k][j];
                    if (Double.compare(ik_kj, this.d[i2][j]) >= 0) continue;
                    this.d[i2][j] = ik_kj;
                    this.backtrace[i2][j] = this.backtrace[i2][k];
                }
            }
        }
    }

    private void populateLastHopMatrix() {
        this.lazyCalculateMatrix();
        if (this.lastHopMatrix != null) {
            return;
        }
        int n = this.vertices.size();
        this.lastHopMatrix = new Object[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i == j || this.lastHopMatrix[i][j] != null || this.backtrace[i][j] == null) continue;
                V u = this.vertices.get(i);
                V b = this.vertices.get(j);
                while (!u.equals(b)) {
                    int v_u = this.vertexIndices.get(u);
                    Object e = TypeUtil.uncheckedCast(this.backtrace[v_u][j], null);
                    V other = Graphs.getOppositeVertex(this.graph, e, u);
                    this.lastHopMatrix[i][this.vertexIndices.get(other).intValue()] = e;
                    u = other;
                }
            }
        }
    }

    class FloydWarshallSingleSourcePaths
    implements ShortestPathAlgorithm.SingleSourcePaths<V, E> {
        private V source;

        public FloydWarshallSingleSourcePaths(V source) {
            this.source = source;
        }

        @Override
        public Graph<V, E> getGraph() {
            return FloydWarshallShortestPaths.this.graph;
        }

        @Override
        public V getSourceVertex() {
            return this.source;
        }

        @Override
        public double getWeight(V sink) {
            if (!FloydWarshallShortestPaths.this.graph.containsVertex(this.source)) {
                throw new IllegalArgumentException("Graph must contain the source vertex!");
            }
            if (!FloydWarshallShortestPaths.this.graph.containsVertex(sink)) {
                throw new IllegalArgumentException("Graph must contain the sink vertex!");
            }
            FloydWarshallShortestPaths.this.lazyCalculateMatrix();
            return FloydWarshallShortestPaths.this.d[(Integer)FloydWarshallShortestPaths.this.vertexIndices.get(this.source)][(Integer)FloydWarshallShortestPaths.this.vertexIndices.get(sink)];
        }

        @Override
        public GraphPath<V, E> getPath(V sink) {
            if (!FloydWarshallShortestPaths.this.graph.containsVertex(this.source)) {
                throw new IllegalArgumentException("Graph must contain the source vertex!");
            }
            if (!FloydWarshallShortestPaths.this.graph.containsVertex(sink)) {
                throw new IllegalArgumentException("Graph must contain the sink vertex!");
            }
            FloydWarshallShortestPaths.this.lazyCalculateMatrix();
            int v_a = (Integer)FloydWarshallShortestPaths.this.vertexIndices.get(this.source);
            int v_b = (Integer)FloydWarshallShortestPaths.this.vertexIndices.get(sink);
            if (FloydWarshallShortestPaths.this.backtrace[v_a][v_b] == null) {
                return FloydWarshallShortestPaths.this.createEmptyPath(this.source, sink);
            }
            ArrayList edges = new ArrayList();
            Object u = this.source;
            while (!u.equals(sink)) {
                int v_u = (Integer)FloydWarshallShortestPaths.this.vertexIndices.get(u);
                Object e = TypeUtil.uncheckedCast(FloydWarshallShortestPaths.this.backtrace[v_u][v_b], null);
                edges.add(e);
                u = Graphs.getOppositeVertex(FloydWarshallShortestPaths.this.graph, e, u);
            }
            return new GraphWalk(FloydWarshallShortestPaths.this.graph, this.source, sink, null, edges, FloydWarshallShortestPaths.this.d[v_a][v_b]);
        }
    }
}

