/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.shortestpath;

import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.BaseShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.DijkstraClosestFirstIterator;

public final class DijkstraShortestPath<V, E>
extends BaseShortestPathAlgorithm<V, E> {
    private final double radius;

    public DijkstraShortestPath(Graph<V, E> graph) {
        this(graph, Double.POSITIVE_INFINITY);
    }

    public DijkstraShortestPath(Graph<V, E> graph, double radius) {
        super(graph);
        if (radius < 0.0) {
            throw new IllegalArgumentException("Radius must be non-negative");
        }
        this.radius = radius;
    }

    @Override
    public GraphPath<V, E> getPath(V source, V sink) {
        V vertex;
        if (!this.graph.containsVertex(source)) {
            throw new IllegalArgumentException("Graph must contain the source vertex!");
        }
        if (!this.graph.containsVertex(sink)) {
            throw new IllegalArgumentException("Graph must contain the sink vertex!");
        }
        if (source.equals(sink)) {
            return this.createEmptyPath(source, sink);
        }
        DijkstraClosestFirstIterator it = new DijkstraClosestFirstIterator(this.graph, source, this.radius);
        while (it.hasNext() && !(vertex = it.next()).equals(sink)) {
        }
        return it.getPaths().getPath(sink);
    }

    @Override
    public ShortestPathAlgorithm.SingleSourcePaths<V, E> getPaths(V source) {
        if (!this.graph.containsVertex(source)) {
            throw new IllegalArgumentException("Graph must contain the source vertex!");
        }
        DijkstraClosestFirstIterator it = new DijkstraClosestFirstIterator(this.graph, source, this.radius);
        while (it.hasNext()) {
            it.next();
        }
        return it.getPaths();
    }

    public static <V, E> GraphPath<V, E> findPathBetween(Graph<V, E> graph, V source, V sink) {
        return new DijkstraShortestPath<V, E>(graph).getPath(source, sink);
    }
}

