/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.pocketlib;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import org.dimdev.ddutils.WorldUtils;
import org.dimdev.ddutils.nbt.INBTStorable;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.pocketlib.Pocket;
import org.dimdev.pocketlib.PocketRegistry;

public class PrivatePocketData
extends WorldSavedData {
    private static final String DATA_NAME = "dimdoors_private_pockets";
    protected BiMap<String, PocketInfo> privatePocketMap = HashBiMap.create();

    public PrivatePocketData(String name) {
        super(name);
    }

    public PrivatePocketData() {
        super(DATA_NAME);
    }

    public static PrivatePocketData instance() {
        MapStorage storage = WorldUtils.getWorld(0).func_175693_T();
        PrivatePocketData instance = (PrivatePocketData)storage.func_75742_a(PrivatePocketData.class, DATA_NAME);
        if (instance == null) {
            instance = new PrivatePocketData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTUtils.readFromNBT(this, nbt);
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        return NBTUtils.writeToNBT((Object)this, nbt);
    }

    public Pocket getPrivatePocket(UUID playerUUID) {
        PocketInfo pocket = (PocketInfo)this.privatePocketMap.get((Object)playerUUID.toString());
        if (pocket == null) {
            return null;
        }
        return PocketRegistry.instance(pocket.dim).getPocket(pocket.id);
    }

    public void setPrivatePocketID(UUID playerUUID, Pocket pocket) {
        this.privatePocketMap.put((Object)playerUUID.toString(), (Object)new PocketInfo(pocket.getDim(), pocket.getId()));
        this.func_76185_a();
    }

    public UUID getPrivatePocketOwner(Pocket pocket) {
        return UUID.fromString((String)this.privatePocketMap.inverse().get((Object)new PocketInfo(pocket.getDim(), pocket.getId())));
    }

    protected static class PocketInfo
    implements INBTStorable {
        protected int dim;
        protected int id;

        @Override
        public void readFromNBT(NBTTagCompound nbt) {
            NBTUtils.readFromNBT(this, nbt);
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            return NBTUtils.writeToNBT(this, nbt);
        }

        public PocketInfo(int dim, int id) {
            this.dim = dim;
            this.id = id;
        }

        public PocketInfo() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PocketInfo)) {
                return false;
            }
            PocketInfo other = (PocketInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.dim != other.dim) {
                return false;
            }
            return this.id == other.id;
        }

        protected boolean canEqual(Object other) {
            return other instanceof PocketInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.dim;
            result = result * 59 + this.id;
            return result;
        }

        public String toString() {
            return "PrivatePocketData.PocketInfo(dim=" + this.dim + ", id=" + this.id + ")";
        }
    }
}

