/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.world.limbo;

import net.minecraft.client.audio.MusicTicker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.render.CloudRenderBlank;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.sound.ModSounds;
import org.dimdev.dimdoors.shared.world.ModBiomes;
import org.dimdev.dimdoors.shared.world.ModDimensions;
import org.dimdev.dimdoors.shared.world.limbo.ChunkGeneratorLimbo;
import org.dimdev.dimdoors.shared.world.limbo.LimboSkyProvider;

public class WorldProviderLimbo
extends WorldProvider {
    @SideOnly(value=Side.CLIENT)
    public static MusicTicker.MusicType music;

    public void func_76572_b() {
        this.field_191067_f = false;
        this.field_76578_c = new BiomeProviderSingle((Biome)ModBiomes.LIMBO);
        DimDoors.proxy.setCloudRenderer(this, new CloudRenderBlank());
        DimDoors.proxy.setSkyRenderer(this, new LimboSkyProvider());
    }

    public boolean func_76567_e() {
        return ModConfig.limbo.hardcoreLimbo;
    }

    protected void func_76556_a() {
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = f1 / (f1 * 3.0f + 1.0f) * 1.0f * 3.0f;
        }
    }

    public BlockPos getSpawnPoint() {
        int x = MathHelper.func_76125_a((int)this.field_76579_a.field_73012_v.nextInt(), (int)-500, (int)500);
        int z = MathHelper.func_76125_a((int)this.field_76579_a.field_73012_v.nextInt(), (int)-500, (int)500);
        return new BlockPos(x, 700, z);
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76559_b(long worldTime) {
        return 4;
    }

    public boolean func_76566_a(int x, int z) {
        BlockPos pos = this.field_76579_a.func_175672_r(new BlockPos(x, 0, z));
        return this.field_76579_a.func_180495_p(pos) == ModBlocks.UNRAVELLED_FABRIC.func_176223_P();
    }

    public double getHorizon() {
        return (double)this.field_76579_a.func_72800_K() / 4.0 - 800.0;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return 0;
    }

    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorLimbo(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public static Location getLimboSkySpawn(Entity entity) {
        int x = (int)entity.field_70165_t + MathHelper.func_76125_a((int)entity.field_70170_p.field_73012_v.nextInt(), (int)100, (int)100);
        int z = (int)entity.field_70161_v + MathHelper.func_76125_a((int)entity.field_70170_p.field_73012_v.nextInt(), (int)-100, (int)100);
        return new Location(ModDimensions.getLimboDim(), x, 700, z);
    }

    public BlockPos getRandomizedSpawnPoint() {
        int x = MathHelper.func_76125_a((int)this.field_76579_a.field_73012_v.nextInt(), (int)-500, (int)500);
        int z = MathHelper.func_76125_a((int)this.field_76579_a.field_73012_v.nextInt(), (int)-500, (int)500);
        return new BlockPos(x, 700, z);
    }

    public DimensionType func_186058_p() {
        return ModDimensions.LIMBO;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        return Vec3d.field_186680_a;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        return new Vec3d(0.2, 0.2, 0.2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public MusicTicker.MusicType getMusicType() {
        return music;
    }

    static {
        if (DimDoors.proxy.isClient()) {
            music = (MusicTicker.MusicType)EnumHelper.addEnum(MusicTicker.MusicType.class, (String)"limbo", (Class[])new Class[]{SoundEvent.class, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{ModSounds.CREEPY, 0, 0});
        }
    }
}

