/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.targets;

import java.util.Set;
import net.minecraft.util.math.Vec3i;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.RGBA;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.rifts.targets.GlobalReference;
import org.dimdev.dimdoors.shared.rifts.targets.ITarget;
import org.dimdev.dimdoors.shared.rifts.targets.LocalReference;
import org.dimdev.dimdoors.shared.rifts.targets.RelativeReference;
import org.dimdev.dimdoors.shared.rifts.targets.VirtualTarget;

public abstract class RiftReference
extends VirtualTarget {
    public static RiftReference tryMakeLocal(Location from, Location to) {
        if (from.getDim() != to.getDim()) {
            return new GlobalReference(to);
        }
        return new LocalReference(to.getPos());
    }

    public static RiftReference tryMakeRelative(Location from, Location to) {
        if (from.getDim() != to.getDim()) {
            return new GlobalReference(to);
        }
        return new RelativeReference(new Vec3i(to.getX() - from.getX(), to.getY() - from.getY(), to.getZ() - from.getZ()));
    }

    public abstract Location getReferencedLocation();

    @Override
    public ITarget receiveOther() {
        return (ITarget)this.getReferencedLocation().getTileEntity();
    }

    @Override
    public void register() {
        RiftRegistry.instance().addLink(this.location, this.getReferencedLocation());
    }

    @Override
    public void unregister() {
        RiftRegistry.instance().removeLink(this.location, this.getReferencedLocation());
    }

    @Override
    public boolean shouldInvalidate(Location deletedRift) {
        return deletedRift.equals(this.getReferencedLocation());
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public RGBA getColor() {
        Set<Location> otherRiftTargets;
        Location target = this.getReferencedLocation();
        if (target != null && RiftRegistry.instance().isRiftAt(target) && (otherRiftTargets = RiftRegistry.instance().getTargets(target)).size() == 1 && otherRiftTargets.contains(this.location)) {
            return new RGBA(0.0f, 1.0f, 0.0f, 1.0f);
        }
        return new RGBA(1.0f, 0.0f, 0.0f, 1.0f);
    }
}

