/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.targets;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.WorldUtils;
import org.dimdev.ddutils.math.MathUtils;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.pockets.PocketGenerator;
import org.dimdev.dimdoors.shared.rifts.registry.LinkProperties;
import org.dimdev.dimdoors.shared.rifts.registry.Rift;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.rifts.targets.GlobalReference;
import org.dimdev.dimdoors.shared.rifts.targets.ITarget;
import org.dimdev.dimdoors.shared.rifts.targets.RiftReference;
import org.dimdev.dimdoors.shared.rifts.targets.Targets;
import org.dimdev.dimdoors.shared.rifts.targets.VirtualTarget;
import org.dimdev.dimdoors.shared.tileentities.TileEntityFloatingRift;
import org.dimdev.dimdoors.shared.tileentities.TileEntityRift;
import org.dimdev.pocketlib.Pocket;
import org.dimdev.pocketlib.VirtualLocation;

public class RandomTarget
extends VirtualTarget {
    protected float newRiftWeight;
    protected double weightMaximum;
    protected double coordFactor;
    protected double positiveDepthFactor;
    protected double negativeDepthFactor;
    protected Set<Integer> acceptedGroups;
    protected boolean noLink;
    protected boolean noLinkBack;

    public RandomTarget() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTUtils.readFromNBT(this, nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        return NBTUtils.writeToNBT(this, nbt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ITarget receiveOther() {
        Location selectedLink;
        VirtualLocation virtualLocationHere = VirtualLocation.fromLocation(this.location);
        HashMap<Location, Float> riftWeights = new HashMap<Location, Float>();
        if (this.newRiftWeight > 0.0f) {
            riftWeights.put(null, Float.valueOf(this.newRiftWeight));
        }
        for (Rift otherRift : RiftRegistry.instance().getRifts()) {
            double otherWeight;
            VirtualLocation otherVirtualLocation = VirtualLocation.fromLocation(otherRift.location);
            if (otherRift.properties == null || (otherWeight = otherRift.isFloating ? (double)otherRift.properties.floatingWeight : (double)otherRift.properties.entranceWeight) == 0.0 || Sets.intersection(this.acceptedGroups, otherRift.properties.groups).isEmpty() || otherVirtualLocation == null || otherRift.properties.linksRemaining == 0) continue;
            double depthDifference = otherVirtualLocation.getDepth() - virtualLocationHere.getDepth();
            double coordDistance = Math.sqrt(this.sq(otherVirtualLocation.getX() - virtualLocationHere.getX()) + this.sq(otherVirtualLocation.getZ() - virtualLocationHere.getZ()));
            double depthFactor = depthDifference > 0.0 ? this.positiveDepthFactor : this.negativeDepthFactor;
            double distance = Math.sqrt(this.sq(this.coordFactor * coordDistance) + this.sq(depthFactor * depthDifference));
            double weight = 4.0 * this.weightMaximum / Math.PI * otherWeight / this.sq(this.sq(this.weightMaximum) / distance + distance);
            riftWeights.put(otherRift.location, Float.valueOf((float)weight));
        }
        if (riftWeights.size() == 0) {
            if (this.newRiftWeight != -1.0f) return null;
            selectedLink = null;
        } else {
            selectedLink = (Location)MathUtils.weightedRandom(riftWeights);
        }
        if (selectedLink == null) {
            double r = Math.random();
            double distance = this.weightMaximum * (2.0 * Math.tan(1.5707963267948966 * r) - 0.5578284481138029 * Math.sqrt(r) * Math.log(r));
            double theta = Math.random() * Math.PI;
            double phi = Math.random() * Math.PI;
            double depth = distance * Math.sin(theta);
            double d = depth > 0.0 ? this.positiveDepthFactor : this.negativeDepthFactor;
            double x = Math.cos(theta) * Math.cos(phi) * distance / this.coordFactor;
            double z = Math.cos(theta) * Math.sin(phi) * distance / this.coordFactor;
            VirtualLocation virtualLocation = new VirtualLocation(virtualLocationHere.getDim(), virtualLocationHere.getX() + (int)Math.round(x), virtualLocationHere.getZ() + (int)Math.round(z), virtualLocationHere.getDepth() + (int)Math.round(depth /= d));
            if (virtualLocation.getDepth() <= 0) {
                WorldServer world = WorldUtils.getWorld(virtualLocation.getDim());
                BlockPos pos = world.func_175672_r(new BlockPos(virtualLocation.getX(), 0, virtualLocation.getZ()));
                if (pos.func_177956_o() == -1) {
                    pos = new BlockPos(virtualLocation.getX(), 0, virtualLocation.getZ());
                }
                world.func_175656_a(pos, ModBlocks.RIFT.func_176223_P());
                TileEntityRift thisRift = (TileEntityRift)this.location.getTileEntity();
                TileEntityFloatingRift riftEntity = (TileEntityFloatingRift)world.func_175625_s(pos);
                riftEntity.setProperties(thisRift.getProperties().toBuilder().linksRemaining(1).build());
                if (!this.noLinkBack && !riftEntity.getProperties().oneWay) {
                    RandomTarget.linkRifts(new Location((World)world, pos), this.location);
                }
                if (this.noLink) return riftEntity.as(Targets.ENTITY);
                RandomTarget.linkRifts(this.location, new Location((World)world, pos));
                return riftEntity.as(Targets.ENTITY);
            }
            TileEntityRift thisRift = (TileEntityRift)this.location.getTileEntity();
            LinkProperties newLink = thisRift.getProperties() != null ? thisRift.getProperties().toBuilder().linksRemaining(0).build() : null;
            Pocket pocket = PocketGenerator.generateDungeonPocket(virtualLocation, new GlobalReference(!this.noLinkBack ? this.location : null), newLink);
            if (this.noLink) return (ITarget)RiftRegistry.instance().getPocketEntrance(pocket).getTileEntity();
            RandomTarget.linkRifts(this.location, RiftRegistry.instance().getPocketEntrance(pocket));
            return (ITarget)RiftRegistry.instance().getPocketEntrance(pocket).getTileEntity();
        }
        TileEntityRift riftEntity = (TileEntityRift)selectedLink.getTileEntity();
        if (!this.noLink) {
            RandomTarget.linkRifts(this.location, selectedLink);
        }
        if (this.noLinkBack || riftEntity.getProperties().oneWay) return riftEntity;
        RandomTarget.linkRifts(selectedLink, this.location);
        return riftEntity;
    }

    private static void linkRifts(Location from, Location to) {
        TileEntityRift tileEntityFrom = (TileEntityRift)from.getTileEntity();
        TileEntityRift tileEntityTo = (TileEntityRift)to.getTileEntity();
        tileEntityFrom.setDestination(RiftReference.tryMakeLocal(from, to));
        tileEntityFrom.func_70296_d();
        if (tileEntityTo.getProperties() != null) {
            --tileEntityTo.getProperties().linksRemaining;
            tileEntityTo.updateProperties();
            tileEntityTo.func_70296_d();
        }
    }

    private double sq(double a) {
        return a * a;
    }

    public static RandomTargetBuilder builder() {
        return new RandomTargetBuilder();
    }

    public RandomTargetBuilder toBuilder() {
        return new RandomTargetBuilder().newRiftWeight(this.newRiftWeight).weightMaximum(this.weightMaximum).coordFactor(this.coordFactor).positiveDepthFactor(this.positiveDepthFactor).negativeDepthFactor(this.negativeDepthFactor).acceptedGroups(this.acceptedGroups).noLink(this.noLink).noLinkBack(this.noLinkBack);
    }

    public float getNewRiftWeight() {
        return this.newRiftWeight;
    }

    public double getWeightMaximum() {
        return this.weightMaximum;
    }

    public double getCoordFactor() {
        return this.coordFactor;
    }

    public double getPositiveDepthFactor() {
        return this.positiveDepthFactor;
    }

    public double getNegativeDepthFactor() {
        return this.negativeDepthFactor;
    }

    public Set<Integer> getAcceptedGroups() {
        return this.acceptedGroups;
    }

    public boolean isNoLink() {
        return this.noLink;
    }

    public boolean isNoLinkBack() {
        return this.noLinkBack;
    }

    public RandomTarget(float newRiftWeight, double weightMaximum, double coordFactor, double positiveDepthFactor, double negativeDepthFactor, Set<Integer> acceptedGroups, boolean noLink, boolean noLinkBack) {
        this.newRiftWeight = newRiftWeight;
        this.weightMaximum = weightMaximum;
        this.coordFactor = coordFactor;
        this.positiveDepthFactor = positiveDepthFactor;
        this.negativeDepthFactor = negativeDepthFactor;
        this.acceptedGroups = acceptedGroups;
        this.noLink = noLink;
        this.noLinkBack = noLinkBack;
    }

    @Override
    public String toString() {
        return "RandomTarget(newRiftWeight=" + this.getNewRiftWeight() + ", weightMaximum=" + this.getWeightMaximum() + ", coordFactor=" + this.getCoordFactor() + ", positiveDepthFactor=" + this.getPositiveDepthFactor() + ", negativeDepthFactor=" + this.getNegativeDepthFactor() + ", acceptedGroups=" + this.getAcceptedGroups() + ", noLink=" + this.isNoLink() + ", noLinkBack=" + this.isNoLinkBack() + ")";
    }

    public static class RandomTargetBuilder {
        private float newRiftWeight;
        private double weightMaximum;
        private double coordFactor;
        private double positiveDepthFactor;
        private double negativeDepthFactor;
        private Set<Integer> acceptedGroups;
        private boolean noLink;
        private boolean noLinkBack;

        RandomTargetBuilder() {
        }

        public RandomTargetBuilder newRiftWeight(float newRiftWeight) {
            this.newRiftWeight = newRiftWeight;
            return this;
        }

        public RandomTargetBuilder weightMaximum(double weightMaximum) {
            this.weightMaximum = weightMaximum;
            return this;
        }

        public RandomTargetBuilder coordFactor(double coordFactor) {
            this.coordFactor = coordFactor;
            return this;
        }

        public RandomTargetBuilder positiveDepthFactor(double positiveDepthFactor) {
            this.positiveDepthFactor = positiveDepthFactor;
            return this;
        }

        public RandomTargetBuilder negativeDepthFactor(double negativeDepthFactor) {
            this.negativeDepthFactor = negativeDepthFactor;
            return this;
        }

        public RandomTargetBuilder acceptedGroups(Set<Integer> acceptedGroups) {
            this.acceptedGroups = acceptedGroups;
            return this;
        }

        public RandomTargetBuilder noLink(boolean noLink) {
            this.noLink = noLink;
            return this;
        }

        public RandomTargetBuilder noLinkBack(boolean noLinkBack) {
            this.noLinkBack = noLinkBack;
            return this;
        }

        public RandomTarget build() {
            return new RandomTarget(this.newRiftWeight, this.weightMaximum, this.coordFactor, this.positiveDepthFactor, this.negativeDepthFactor, this.acceptedGroups, this.noLink, this.noLinkBack);
        }

        public String toString() {
            return "RandomTarget.RandomTargetBuilder(newRiftWeight=" + this.newRiftWeight + ", weightMaximum=" + this.weightMaximum + ", coordFactor=" + this.coordFactor + ", positiveDepthFactor=" + this.positiveDepthFactor + ", negativeDepthFactor=" + this.negativeDepthFactor + ", acceptedGroups=" + this.acceptedGroups + ", noLink=" + this.noLink + ", noLinkBack=" + this.noLinkBack + ")";
        }
    }
}

