/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.targets;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.dimdev.ddutils.EntityUtils;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.RGBA;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.pockets.PocketGenerator;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.rifts.targets.IEntityTarget;
import org.dimdev.dimdoors.shared.rifts.targets.VirtualTarget;
import org.dimdev.pocketlib.Pocket;
import org.dimdev.pocketlib.PrivatePocketData;
import org.dimdev.pocketlib.VirtualLocation;

public class PrivatePocketTarget
extends VirtualTarget
implements IEntityTarget {
    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public boolean receiveEntity(Entity entity, float relativeYaw, float relativePitch) {
        UUID uuid = EntityUtils.getEntityOwnerUUID(entity);
        VirtualLocation virtualLocation = VirtualLocation.fromLocation(this.location);
        if (uuid != null) {
            Pocket pocket = PrivatePocketData.instance().getPrivatePocket(uuid);
            if (pocket == null) {
                pocket = PocketGenerator.generatePrivatePocket(virtualLocation != null ? virtualLocation.toBuilder().depth(-1).build() : null);
                PrivatePocketData.instance().setPrivatePocketID(uuid, pocket);
                ((IEntityTarget)RiftRegistry.instance().getPocketEntrance(pocket).getTileEntity()).receiveEntity(entity, relativeYaw, relativePitch);
                RiftRegistry.instance().setLastPrivatePocketExit(uuid, this.location);
                return true;
            }
            Location destLoc = RiftRegistry.instance().getPrivatePocketEntrance(uuid);
            if (destLoc == null) {
                destLoc = RiftRegistry.instance().getPocketEntrance(pocket);
            }
            if (destLoc == null) {
                DimDoors.log.info("All entrances are gone, creating a new private pocket!");
                pocket = PocketGenerator.generatePrivatePocket(virtualLocation != null ? virtualLocation.toBuilder().depth(-1).build() : null);
                PrivatePocketData.instance().setPrivatePocketID(uuid, pocket);
                destLoc = RiftRegistry.instance().getPocketEntrance(pocket);
            }
            ((IEntityTarget)destLoc.getTileEntity()).receiveEntity(entity, relativeYaw, relativePitch);
            RiftRegistry.instance().setLastPrivatePocketExit(uuid, this.location);
            return true;
        }
        return false;
    }

    @Override
    public RGBA getColor() {
        return new RGBA(0.0f, 1.0f, 0.0f, 1.0f);
    }

    public static PrivatePocketTargetBuilder builder() {
        return new PrivatePocketTargetBuilder();
    }

    public PrivatePocketTargetBuilder toBuilder() {
        return new PrivatePocketTargetBuilder();
    }

    @Override
    public String toString() {
        return "PrivatePocketTarget()";
    }

    public static class PrivatePocketTargetBuilder {
        PrivatePocketTargetBuilder() {
        }

        public PrivatePocketTarget build() {
            return new PrivatePocketTarget();
        }

        public String toString() {
            return "PrivatePocketTarget.PrivatePocketTargetBuilder()";
        }
    }
}

