/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.targets;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.nbt.NBTUtils;
import org.dimdev.dimdoors.shared.rifts.targets.RiftReference;

public class LocalReference
extends RiftReference {
    protected BlockPos target;

    public LocalReference() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        NBTUtils.readFromNBT(this, nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        return NBTUtils.writeToNBT(this, nbt);
    }

    @Override
    public Location getReferencedLocation() {
        return new Location(this.location.getDim(), this.target);
    }

    public static LocalReferenceBuilder builder() {
        return new LocalReferenceBuilder();
    }

    public LocalReferenceBuilder toBuilder() {
        return new LocalReferenceBuilder().target(this.target);
    }

    public BlockPos getTarget() {
        return this.target;
    }

    public LocalReference(BlockPos target) {
        this.target = target;
    }

    @Override
    public String toString() {
        return "LocalReference(target=" + this.getTarget() + ")";
    }

    public static class LocalReferenceBuilder {
        private BlockPos target;

        LocalReferenceBuilder() {
        }

        public LocalReferenceBuilder target(BlockPos target) {
            this.target = target;
            return this;
        }

        public LocalReference build() {
            return new LocalReference(this.target);
        }

        public String toString() {
            return "LocalReference.LocalReferenceBuilder(target=" + this.target + ")";
        }
    }
}

