/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.targets;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.TeleportUtils;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.rifts.targets.IEntityTarget;
import org.dimdev.dimdoors.shared.rifts.targets.VirtualTarget;
import org.dimdev.dimdoors.shared.tileentities.TileEntityRift;
import org.dimdev.dimdoors.shared.world.ModDimensions;
import org.dimdev.dimdoors.shared.world.limbo.WorldProviderLimbo;
import org.dimdev.pocketlib.VirtualLocation;

public class EscapeTarget
extends VirtualTarget
implements IEntityTarget {
    protected boolean canEscapeLimbo;

    public EscapeTarget() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public boolean receiveEntity(Entity entity, float relativeYaw, float relativePitch) {
        if (!ModDimensions.isDimDoorsPocketDimension(entity.field_70170_p) && !(entity.field_70170_p.field_73011_w instanceof WorldProviderLimbo)) {
            DimDoors.sendTranslatedMessage(entity, "rifts.destinations.escape.not_in_pocket_dim", new Object[0]);
            return false;
        }
        if (entity.field_70170_p.field_73011_w instanceof WorldProviderLimbo && !this.canEscapeLimbo) {
            DimDoors.sendTranslatedMessage(entity, "rifts.destinations.escape.cannot_escape_limbo", new Object[0]);
            return false;
        }
        UUID uuid = entity.func_110124_au();
        if (uuid != null) {
            Location destLoc = RiftRegistry.instance().getOverworldRift(uuid);
            if (destLoc != null && destLoc.getTileEntity() instanceof TileEntityRift || this.canEscapeLimbo) {
                TeleportUtils.teleport(entity, VirtualLocation.fromLocation(new Location(entity.field_70170_p, entity.func_180425_c())).projectToWorld(false));
                return true;
            }
            if (destLoc == null) {
                DimDoors.sendTranslatedMessage(entity, "rifts.destinations.escape.did_not_use_rift", new Object[0]);
            } else {
                DimDoors.sendTranslatedMessage(entity, "rifts.destinations.escape.rift_has_closed", new Object[0]);
            }
            TeleportUtils.teleport(entity, WorldProviderLimbo.getLimboSkySpawn(entity));
            return true;
        }
        return false;
    }

    private static boolean $default$canEscapeLimbo() {
        return false;
    }

    public static EscapeTargetBuilder builder() {
        return new EscapeTargetBuilder();
    }

    public EscapeTargetBuilder toBuilder() {
        return new EscapeTargetBuilder().canEscapeLimbo(this.canEscapeLimbo);
    }

    public boolean isCanEscapeLimbo() {
        return this.canEscapeLimbo;
    }

    public EscapeTarget(boolean canEscapeLimbo) {
        this.canEscapeLimbo = canEscapeLimbo;
    }

    @Override
    public String toString() {
        return "EscapeTarget(canEscapeLimbo=" + this.isCanEscapeLimbo() + ")";
    }

    public static class EscapeTargetBuilder {
        private boolean canEscapeLimbo$set;
        private boolean canEscapeLimbo;

        EscapeTargetBuilder() {
        }

        public EscapeTargetBuilder canEscapeLimbo(boolean canEscapeLimbo) {
            this.canEscapeLimbo = canEscapeLimbo;
            this.canEscapeLimbo$set = true;
            return this;
        }

        public EscapeTarget build() {
            boolean canEscapeLimbo = this.canEscapeLimbo;
            if (!this.canEscapeLimbo$set) {
                canEscapeLimbo = EscapeTarget.$default$canEscapeLimbo();
            }
            return new EscapeTarget(canEscapeLimbo);
        }

        public String toString() {
            return "EscapeTarget.EscapeTargetBuilder(canEscapeLimbo=" + this.canEscapeLimbo + ")";
        }
    }
}

