/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.rifts.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import org.dimdev.ddutils.GraphUtils;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.WorldUtils;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.rifts.registry.LinkProperties;
import org.dimdev.dimdoors.shared.rifts.registry.PlayerRiftPointer;
import org.dimdev.dimdoors.shared.rifts.registry.PocketEntrancePointer;
import org.dimdev.dimdoors.shared.rifts.registry.RegistryVertex;
import org.dimdev.dimdoors.shared.rifts.registry.Rift;
import org.dimdev.dimdoors.shared.rifts.registry.RiftPlaceholder;
import org.dimdev.pocketlib.Pocket;
import org.dimdev.pocketlib.PocketRegistry;
import org.dimdev.pocketlib.PrivatePocketData;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class RiftRegistry
extends WorldSavedData {
    private static final String DATA_NAME = "dimdoors_global_rifts";
    private static final String SUBREGISTRY_DATA_NAME = "dimdoors_rifts";
    protected Map<Integer, RiftSubregistry> subregistries = new HashMap<Integer, RiftSubregistry>();
    private static RiftRegistry riftRegistry = null;
    private static int currentDim;
    protected DefaultDirectedGraph<RegistryVertex, DefaultEdge> graph = new DefaultDirectedGraph(DefaultEdge.class);
    protected Map<Location, Rift> locationMap = new HashMap<Location, Rift>();
    protected Map<Pocket, PocketEntrancePointer> pocketEntranceMap = new HashMap<Pocket, PocketEntrancePointer>();
    protected Map<UUID, RegistryVertex> uuidMap = new HashMap<UUID, RegistryVertex>();
    protected Map<UUID, PlayerRiftPointer> lastPrivatePocketEntrances = new HashMap<UUID, PlayerRiftPointer>();
    protected Map<UUID, PlayerRiftPointer> lastPrivatePocketExits = new HashMap<UUID, PlayerRiftPointer>();
    protected Map<UUID, PlayerRiftPointer> overworldRifts = new HashMap<UUID, PlayerRiftPointer>();

    public RiftRegistry() {
        super(DATA_NAME);
    }

    public RiftRegistry(String s) {
        super(s);
    }

    public static RiftRegistry instance() {
        MapStorage storage = WorldUtils.getWorld(0).func_175693_T();
        RiftRegistry instance = (RiftRegistry)storage.func_75742_a(RiftRegistry.class, DATA_NAME);
        if (instance == null) {
            instance = new RiftRegistry();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        return instance;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        riftRegistry = this;
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dim = integerArray[i];
            MapStorage storage = WorldUtils.getWorld(dim).getPerWorldStorage();
            currentDim = dim;
            RiftSubregistry instance = (RiftSubregistry)storage.func_75742_a(RiftSubregistry.class, SUBREGISTRY_DATA_NAME);
            if (instance == null) continue;
            instance.dim = dim;
            this.subregistries.put(dim, instance);
        }
        riftRegistry = null;
        this.lastPrivatePocketEntrances = this.readPlayerRiftPointers((NBTTagList)nbt.func_74781_a("lastPrivatePocketEntrances"));
        this.lastPrivatePocketExits = this.readPlayerRiftPointers((NBTTagList)nbt.func_74781_a("lastPrivatePocketExits"));
        this.overworldRifts = this.readPlayerRiftPointers((NBTTagList)nbt.func_74781_a("overworldRifts"));
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74782_a("lastPrivatePocketEntrances", (NBTBase)this.writePlayerRiftPointers(this.lastPrivatePocketEntrances));
        nbt.func_74782_a("lastPrivatePocketExits", (NBTBase)this.writePlayerRiftPointers(this.lastPrivatePocketExits));
        nbt.func_74782_a("overworldRifts", (NBTBase)this.writePlayerRiftPointers(this.overworldRifts));
        return nbt;
    }

    private Map<UUID, PlayerRiftPointer> readPlayerRiftPointers(NBTTagList playerRiftPointersNBT) {
        HashMap<UUID, PlayerRiftPointer> pointerMap = new HashMap<UUID, PlayerRiftPointer>();
        for (NBTBase entryNBT : playerRiftPointersNBT) {
            UUID player = ((NBTTagCompound)entryNBT).func_186857_a("player");
            UUID rift = ((NBTTagCompound)entryNBT).func_186857_a("rift");
            PlayerRiftPointer pointer = new PlayerRiftPointer(player);
            pointerMap.put(player, pointer);
            this.uuidMap.put(pointer.id, pointer);
            this.graph.addVertex(pointer);
            this.graph.addEdge(pointer, this.uuidMap.get(rift));
        }
        return pointerMap;
    }

    private NBTTagList writePlayerRiftPointers(Map<UUID, PlayerRiftPointer> playerRiftPointerMap) {
        NBTTagList pointers = new NBTTagList();
        for (Map.Entry<UUID, PlayerRiftPointer> entry : playerRiftPointerMap.entrySet()) {
            NBTTagCompound entryNBT = new NBTTagCompound();
            entryNBT.func_186854_a("player", entry.getKey());
            int count = 0;
            for (DefaultEdge edge : this.graph.outgoingEdgesOf(entry.getValue())) {
                entryNBT.func_186854_a("rift", ((RegistryVertex)this.graph.getEdgeTarget((DefaultEdge)edge)).id);
                ++count;
            }
            if (count != 1) {
                throw new RuntimeException("PlayerRiftPointer points to more than one rift");
            }
            pointers.func_74742_a((NBTBase)entryNBT);
        }
        return pointers;
    }

    public void markSubregistryDirty(int dim) {
        RiftSubregistry subregistry = this.subregistries.get(dim);
        if (subregistry != null) {
            subregistry.func_76185_a();
        } else {
            MapStorage storage = WorldUtils.getWorld(dim).getPerWorldStorage();
            RiftSubregistry instance = new RiftSubregistry();
            instance.dim = dim;
            instance.func_76185_a();
            storage.func_75745_a(SUBREGISTRY_DATA_NAME, (WorldSavedData)instance);
            this.subregistries.put(dim, instance);
        }
    }

    public boolean isRiftAt(Location location) {
        Rift possibleRift = this.locationMap.get(location);
        return possibleRift != null && !(possibleRift instanceof RiftPlaceholder);
    }

    public Rift getRift(Location location) {
        Rift rift = this.locationMap.get(location);
        if (rift == null) {
            throw new IllegalArgumentException("There is no rift registered at " + location);
        }
        return rift;
    }

    private Rift getRiftOrPlaceholder(Location location) {
        Rift rift = this.locationMap.get(location);
        if (rift == null) {
            DimDoors.log.debug("Creating a rift placeholder at " + location);
            rift = new RiftPlaceholder();
            rift.dim = location.getDim();
            rift.location = location;
            this.locationMap.put(location, rift);
            this.uuidMap.put(rift.id, rift);
            this.graph.addVertex(rift);
            this.markSubregistryDirty(rift.dim);
        }
        return rift;
    }

    public void addRift(Location location) {
        Rift rift;
        DimDoors.log.debug("Adding rift at " + location);
        RegistryVertex currentRift = this.locationMap.get(location);
        if (currentRift instanceof RiftPlaceholder) {
            DimDoors.log.info("Converting a rift placeholder at " + location + " into a rift");
            rift = new Rift(location);
            rift.dim = location.getDim();
            rift.id = currentRift.id;
            GraphUtils.replaceVertex(this.graph, currentRift, rift);
        } else if (currentRift == null) {
            rift = new Rift(location);
            rift.dim = location.getDim();
            this.graph.addVertex(rift);
        } else {
            throw new IllegalArgumentException("There is already a rift registered at " + location);
        }
        this.uuidMap.put(rift.id, rift);
        this.locationMap.put(location, rift);
        rift.markDirty();
    }

    public void removeRift(Location location) {
        DimDoors.log.debug("Removing rift at " + location);
        if (this.isRiftAt(location)) {
            Rift rift = this.getRift(location);
            Set incomingEdges = this.graph.incomingEdgesOf(rift);
            Set outgoingEdges = this.graph.outgoingEdgesOf(rift);
            this.graph.removeVertex(rift);
            this.locationMap.remove(location);
            this.uuidMap.remove(rift.id);
            this.markSubregistryDirty(rift.dim);
            for (DefaultEdge edge : incomingEdges) {
                ((RegistryVertex)this.graph.getEdgeSource(edge)).targetGone(rift);
            }
            for (DefaultEdge edge : outgoingEdges) {
                ((RegistryVertex)this.graph.getEdgeTarget(edge)).sourceGone(rift);
            }
        } else {
            DimDoors.log.debug("No rift to remove at " + location);
        }
    }

    private void addEdge(RegistryVertex from, RegistryVertex to) {
        this.graph.addEdge(from, to);
        if (from instanceof PlayerRiftPointer) {
            this.func_76185_a();
        } else if (from instanceof Rift) {
            ((Rift)from).markDirty();
        } else {
            this.markSubregistryDirty(from.dim);
        }
        if (to instanceof Rift) {
            ((Rift)to).markDirty();
        } else {
            this.markSubregistryDirty(to.dim);
        }
    }

    private void removeEdge(RegistryVertex from, RegistryVertex to) {
        this.graph.removeEdge(from, to);
        if (from instanceof PlayerRiftPointer) {
            this.func_76185_a();
        } else {
            this.markSubregistryDirty(from.dim);
        }
        this.markSubregistryDirty(to.dim);
    }

    public void addLink(Location locationFrom, Location locationTo) {
        DimDoors.log.debug("Adding link " + locationFrom + " -> " + locationTo);
        Rift from = this.getRiftOrPlaceholder(locationFrom);
        Rift to = this.getRiftOrPlaceholder(locationTo);
        this.addEdge(from, to);
        if (!(from instanceof RiftPlaceholder) && !(to instanceof RiftPlaceholder)) {
            from.targetAdded(to);
            to.sourceAdded(from);
        }
    }

    public void removeLink(Location locationFrom, Location locationTo) {
        DimDoors.log.debug("Removing link " + locationFrom + " -> " + locationTo);
        if (this.isRiftAt(locationFrom) && this.isRiftAt(locationTo)) {
            Rift from = this.getRift(locationFrom);
            Rift to = this.getRift(locationTo);
            this.removeEdge(from, to);
            from.targetGone(to);
            to.sourceGone(from);
        } else {
            DimDoors.log.error("Error removing link " + locationFrom + " -> " + locationTo + " as one of the rifts did not exist");
        }
    }

    public void setProperties(Location location, LinkProperties properties) {
        DimDoors.log.debug("Setting DungeonLinkProperties for rift at " + location + " to " + properties);
        if (this.isRiftAt(location)) {
            Rift rift = this.getRift(location);
            rift.properties = properties;
            rift.markDirty();
        } else {
            DimDoors.log.debug("No rift at " + location + " to set properties for!");
        }
    }

    public Set<Location> getPocketEntrances(Pocket pocket) {
        PocketEntrancePointer pointer = this.pocketEntranceMap.get(pocket);
        if (pointer == null) {
            return Collections.emptySet();
        }
        return this.graph.outgoingEdgesOf(pointer).stream().map(this.graph::getEdgeTarget).map(Rift.class::cast).map(rift -> rift.location).collect(Collectors.toSet());
    }

    public Location getPocketEntrance(Pocket pocket) {
        return this.getPocketEntrances(pocket).stream().findFirst().orElse(null);
    }

    public void addPocketEntrance(Pocket pocket, Location location) {
        DimDoors.log.debug("Adding pocket entrance for pocket " + pocket.getId() + " in dimension " + pocket.getDim() + " at " + location);
        if (this.isRiftAt(location)) {
            PocketEntrancePointer pointer = this.pocketEntranceMap.get(pocket);
            if (pointer == null) {
                pointer = new PocketEntrancePointer(pocket.getDim(), pocket.getId());
                pointer.dim = pocket.getDim();
                this.graph.addVertex(pointer);
                this.pocketEntranceMap.put(pocket, pointer);
                this.uuidMap.put(pointer.id, pointer);
            }
            Rift rift = this.getRift(location);
            this.addEdge(pointer, rift);
        } else {
            DimDoors.log.error("Failed to add entrance for pocket " + pocket.getId() + " in dimension " + pocket.getDim() + " at " + location + "! You should report this!");
        }
    }

    public Location getPrivatePocketEntrance(UUID playerUUID) {
        PlayerRiftPointer entrancePointer = this.lastPrivatePocketEntrances.get(playerUUID);
        Rift entrance = (Rift)((Object)GraphUtils.followPointer(this.graph, entrancePointer));
        if (entrance != null) {
            return entrance.location;
        }
        return this.getPocketEntrance(PrivatePocketData.instance().getPrivatePocket(playerUUID));
    }

    private void setPlayerRiftPointer(UUID playerUUID, Location rift, Map<UUID, PlayerRiftPointer> map) {
        PlayerRiftPointer pointer = map.get(playerUUID);
        if (pointer != null) {
            this.graph.removeVertex(pointer);
            map.remove(playerUUID);
            this.uuidMap.remove(pointer.id);
        }
        if (rift != null) {
            pointer = new PlayerRiftPointer(playerUUID);
            this.graph.addVertex(pointer);
            map.put(playerUUID, pointer);
            this.uuidMap.put(pointer.id, pointer);
            this.addEdge(pointer, this.getRift(rift));
        }
    }

    public void setLastPrivatePocketEntrance(UUID playerUUID, Location rift) {
        DimDoors.log.debug("Setting last used private pocket entrance for " + playerUUID + " at " + rift);
        this.setPlayerRiftPointer(playerUUID, rift, this.lastPrivatePocketEntrances);
    }

    public Location getPrivatePocketExit(UUID playerUUID) {
        PlayerRiftPointer entrancePointer = this.lastPrivatePocketExits.get(playerUUID);
        Rift entrance = (Rift)((Object)GraphUtils.followPointer(this.graph, entrancePointer));
        return entrance != null ? entrance.location : null;
    }

    public void setLastPrivatePocketExit(UUID playerUUID, Location rift) {
        DimDoors.log.debug("Setting last used private pocket exit for " + playerUUID + " at " + rift);
        this.setPlayerRiftPointer(playerUUID, rift, this.lastPrivatePocketExits);
    }

    public Location getOverworldRift(UUID playerUUID) {
        PlayerRiftPointer entrancePointer = this.overworldRifts.get(playerUUID);
        Rift rift = (Rift)((Object)GraphUtils.followPointer(this.graph, entrancePointer));
        return rift != null ? rift.location : null;
    }

    public void setOverworldRift(UUID playerUUID, Location rift) {
        DimDoors.log.debug("Setting last used overworld rift for " + playerUUID + " at " + rift);
        this.setPlayerRiftPointer(playerUUID, rift, this.overworldRifts);
    }

    public Collection<Rift> getRifts() {
        return this.locationMap.values();
    }

    public Set<Location> getTargets(Location location) {
        if (this.isRiftAt(location)) {
            return this.graph.outgoingEdgesOf(this.getRift(location)).stream().map(this.graph::getEdgeTarget).map(Rift.class::cast).map(rift -> rift.location).collect(Collectors.toSet());
        }
        DimDoors.log.error("No rift at location " + location + "! Cannot get targets!");
        return new HashSet<Location>(new ArrayList());
    }

    public Set<Location> getSources(Location location) {
        if (this.isRiftAt(location)) {
            return this.graph.incomingEdgesOf(this.getRift(location)).stream().map(this.graph::getEdgeTarget).map(Rift.class::cast).map(rift -> rift.location).collect(Collectors.toSet());
        }
        DimDoors.log.error("No rift at location " + location + "! Cannot get sources!");
        return new HashSet<Location>(new ArrayList());
    }

    public static class RiftSubregistry
    extends WorldSavedData {
        private int dim;

        public RiftSubregistry() {
            super(RiftRegistry.SUBREGISTRY_DATA_NAME);
        }

        public RiftSubregistry(String s) {
            super(s);
        }

        public void func_76184_a(NBTTagCompound nbt) {
            this.dim = currentDim;
            if (riftRegistry == null || riftRegistry.subregistries.get(this.dim) != null) {
                return;
            }
            NBTTagList riftsNBT = (NBTTagList)nbt.func_74781_a("rifts");
            for (Object riftNBT : riftsNBT) {
                Rift rift = new Rift();
                rift.readFromNBT((NBTTagCompound)riftNBT);
                rift.dim = this.dim;
                riftRegistry.graph.addVertex(rift);
                riftRegistry.uuidMap.put(rift.id, rift);
                riftRegistry.locationMap.put(rift.location, rift);
            }
            NBTTagList pocketsNBT = (NBTTagList)nbt.func_74781_a("pockets");
            for (NBTBase pocketNBT : pocketsNBT) {
                PocketEntrancePointer pocket = new PocketEntrancePointer();
                pocket.readFromNBT((NBTTagCompound)pocketNBT);
                pocket.dim = this.dim;
                riftRegistry.graph.addVertex(pocket);
                riftRegistry.uuidMap.put(pocket.id, pocket);
                riftRegistry.pocketEntranceMap.put(PocketRegistry.instance(pocket.dim).getPocket(pocket.pocketId), pocket);
            }
            NBTTagList linksNBT = (NBTTagList)nbt.func_74781_a("links");
            for (NBTBase linkNBT : linksNBT) {
                RegistryVertex from = riftRegistry.uuidMap.get(((NBTTagCompound)linkNBT).func_186857_a("from"));
                RegistryVertex to = riftRegistry.uuidMap.get(((NBTTagCompound)linkNBT).func_186857_a("to"));
                if (from == null || to == null) continue;
                riftRegistry.graph.addEdge(from, to);
            }
        }

        public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
            if (riftRegistry == null) {
                riftRegistry = RiftRegistry.instance();
            }
            NBTTagList riftsNBT = new NBTTagList();
            NBTTagList pocketsNBT = new NBTTagList();
            for (RegistryVertex vertex : riftRegistry.graph.vertexSet()) {
                if (vertex.dim != this.dim) continue;
                NBTTagCompound vertexNBT = vertex.writeToNBT(new NBTTagCompound());
                if (vertex instanceof Rift) {
                    riftsNBT.func_74742_a((NBTBase)vertexNBT);
                    continue;
                }
                if (vertex instanceof PocketEntrancePointer) {
                    pocketsNBT.func_74742_a((NBTBase)vertexNBT);
                    continue;
                }
                if (vertex instanceof PlayerRiftPointer) continue;
                throw new RuntimeException("Unsupported registry vertex type " + vertex.getClass().getName());
            }
            nbt.func_74782_a("rifts", (NBTBase)riftsNBT);
            nbt.func_74782_a("pockets", (NBTBase)pocketsNBT);
            NBTTagList linksNBT = new NBTTagList();
            for (DefaultEdge edge : riftRegistry.graph.edgeSet()) {
                RegistryVertex from = (RegistryVertex)riftRegistry.graph.getEdgeSource(edge);
                RegistryVertex to = (RegistryVertex)riftRegistry.graph.getEdgeTarget(edge);
                if (from.dim != this.dim && (to.dim != this.dim || from instanceof PlayerRiftPointer)) continue;
                NBTTagCompound linkNBT = new NBTTagCompound();
                linkNBT.func_186854_a("from", from.id);
                linkNBT.func_186854_a("to", to.id);
                linksNBT.func_74742_a((NBTBase)linkNBT);
            }
            nbt.func_74782_a("links", (NBTBase)linksNBT);
            return nbt;
        }
    }
}

