/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.dimdev.dimdoors.DimDoors;
import org.dimdev.dimdoors.shared.blocks.IRiftProvider;
import org.dimdev.dimdoors.shared.tileentities.TileEntityFloatingRift;
import org.dimdev.dimdoors.shared.tileentities.TileEntityRift;

public final class RayTraceHelper {
    public static boolean isFloatingRift(RayTraceResult hit, World world) {
        return hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175625_s(hit.func_178782_a()) instanceof TileEntityFloatingRift;
    }

    public static boolean isRift(RayTraceResult hit, World world) {
        return hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK && world.func_175625_s(hit.func_178782_a()) instanceof TileEntityRift;
    }

    public static boolean isLivingEntity(RayTraceResult hit) {
        return hit != null && hit.field_72313_a == RayTraceResult.Type.ENTITY && hit.field_72308_g instanceof EntityLivingBase;
    }

    public static RayTraceResult rayTraceEntity(World world, EntityPlayer player, double range, float partialTicks) {
        Vec3d playerEyesVector = player.func_174824_e(partialTicks);
        Vec3d playerLookVector = player.func_70040_Z();
        RayTraceResult firstHitBlock = RayTraceHelper.rayTraceForRiftTools(world, player, range);
        if (firstHitBlock != null) {
            Vec3d hitVector = firstHitBlock.field_72307_f;
            range = hitVector.func_72438_d(playerEyesVector);
        }
        Vec3d tempVec = playerEyesVector;
        for (double d = 0.2; d < range; d += 0.2) {
            Vec3d tempVec2 = playerEyesVector.func_178787_e(playerLookVector.func_186678_a(d));
            List entities = world.func_72872_a(EntityLiving.class, new AxisAlignedBB(tempVec.field_72450_a, tempVec.field_72448_b, tempVec.field_72449_c, tempVec2.field_72450_a, tempVec2.field_72448_b, tempVec2.field_72449_c));
            for (EntityLiving entity : entities) {
                if (entity == null) continue;
                AxisAlignedBB entityHitbox = entity.func_174813_aQ();
                if (entityHitbox == null) {
                    DimDoors.log.warn("The hitbox of Entity: " + entity + " was null, somehow");
                    continue;
                }
                if (!entityHitbox.func_72318_a(tempVec2)) continue;
                return new RayTraceResult((Entity)entity);
            }
            tempVec = tempVec2;
        }
        return firstHitBlock;
    }

    public static RayTraceResult rayTraceForRiftTools(World worldIn, EntityPlayer playerIn) {
        return RayTraceHelper.rayTraceForRiftTools(worldIn, playerIn, playerIn.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e());
    }

    public static RayTraceResult rayTraceForRiftTools(World worldIn, EntityPlayer player, double range) {
        Vec3d playerLookVector = player.func_70040_Z();
        Vec3d tempVector = player.func_174824_e(1.0f);
        Vec3d endVector = tempVector.func_178787_e(playerLookVector.func_186678_a(range));
        if (!(Double.isNaN(tempVector.field_72450_a) || Double.isNaN(tempVector.field_72448_b) || Double.isNaN(tempVector.field_72449_c) || Double.isNaN(endVector.field_72450_a) || Double.isNaN(endVector.field_72448_b) || Double.isNaN(endVector.field_72449_c))) {
            RayTraceResult raytraceresult;
            int playerZ;
            int playerY;
            int endX = MathHelper.func_76128_c((double)endVector.field_72450_a);
            int endY = MathHelper.func_76128_c((double)endVector.field_72448_b);
            int endZ = MathHelper.func_76128_c((double)endVector.field_72449_c);
            int playerX = MathHelper.func_76128_c((double)tempVector.field_72450_a);
            BlockPos blockpos = new BlockPos(playerX, playerY = MathHelper.func_76128_c((double)tempVector.field_72448_b), playerZ = MathHelper.func_76128_c((double)tempVector.field_72449_c));
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            Block block = iblockstate.func_177230_c();
            if ((block.func_176209_a(iblockstate, false) || block instanceof IRiftProvider) && (raytraceresult = iblockstate.func_185910_a(worldIn, blockpos, tempVector, endVector)) != null) {
                return raytraceresult;
            }
            int counter = 200;
            while (counter-- >= 0) {
                RayTraceResult raytraceresult1;
                IBlockState iblockstate1;
                Block block1;
                EnumFacing enumfacing;
                if (Double.isNaN(tempVector.field_72450_a) || Double.isNaN(tempVector.field_72448_b) || Double.isNaN(tempVector.field_72449_c) || playerX == endX && playerY == endY && playerZ == endZ) {
                    return null;
                }
                boolean xFlag = true;
                boolean yFlag = true;
                boolean zFlag = true;
                double x1 = 999.0;
                double y1 = 999.0;
                double z1 = 999.0;
                if (endX > playerX) {
                    x1 = (double)playerX + 1.0;
                } else if (endX < playerX) {
                    x1 = playerX;
                } else {
                    xFlag = false;
                }
                if (endY > playerY) {
                    y1 = (double)playerY + 1.0;
                } else if (endY < playerY) {
                    y1 = playerY;
                } else {
                    yFlag = false;
                }
                if (endZ > playerZ) {
                    z1 = (double)playerZ + 1.0;
                } else if (endZ < playerZ) {
                    z1 = playerZ;
                } else {
                    zFlag = false;
                }
                double x2 = endVector.field_72450_a - tempVector.field_72450_a;
                double y2 = endVector.field_72448_b - tempVector.field_72448_b;
                double z2 = endVector.field_72449_c - tempVector.field_72449_c;
                double x3 = 999.0;
                double y3 = 999.0;
                double z3 = 999.0;
                if (xFlag) {
                    x3 = (x1 - tempVector.field_72450_a) / x2;
                }
                if (yFlag) {
                    y3 = (y1 - tempVector.field_72448_b) / y2;
                }
                if (zFlag) {
                    z3 = (z1 - tempVector.field_72449_c) / z2;
                }
                if (x3 == -0.0) {
                    x3 = -1.0E-4;
                }
                if (y3 == -0.0) {
                    y3 = -1.0E-4;
                }
                if (z3 == -0.0) {
                    z3 = -1.0E-4;
                }
                if (x3 < y3 && x3 < z3) {
                    enumfacing = endX > playerX ? EnumFacing.WEST : EnumFacing.EAST;
                    tempVector = new Vec3d(x1, tempVector.field_72448_b + y2 * x3, tempVector.field_72449_c + z2 * x3);
                } else if (y3 < z3) {
                    enumfacing = endY > playerY ? EnumFacing.DOWN : EnumFacing.UP;
                    tempVector = new Vec3d(tempVector.field_72450_a + x2 * y3, y1, tempVector.field_72449_c + z2 * y3);
                } else {
                    enumfacing = endZ > playerZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    tempVector = new Vec3d(tempVector.field_72450_a + x2 * z3, tempVector.field_72448_b + y2 * z3, z1);
                }
                if (!(block1 = (iblockstate1 = worldIn.func_180495_p(blockpos = new BlockPos(playerX = MathHelper.func_76128_c((double)tempVector.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0), playerY = MathHelper.func_76128_c((double)tempVector.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0), playerZ = MathHelper.func_76128_c((double)tempVector.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0)))).func_177230_c()).func_176209_a(iblockstate1, false) && !(block1 instanceof IRiftProvider) || (raytraceresult1 = iblockstate1.func_185910_a(worldIn, blockpos, tempVector, endVector)) == null) continue;
                return raytraceresult1;
            }
        }
        return null;
    }
}

