/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.items;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.dimdoors.client.TileEntityFloatingRiftRenderer;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.items.ModCreativeTabs;
import org.dimdev.dimdoors.shared.items.RayTraceHelper;
import org.dimdev.dimdoors.shared.sound.ModSounds;
import org.dimdev.dimdoors.shared.tileentities.TileEntityFloatingRift;

public class ItemRiftRemover
extends Item {
    public static final String ID = "rift_remover";

    public ItemRiftRemover() {
        this.func_77637_a(ModCreativeTabs.DIMENSIONAL_DOORS_CREATIVE_TAB);
        this.func_77655_b(ID);
        this.setRegistryName(new ResourceLocation("dimdoors", ID));
        this.func_77625_d(1);
        this.func_77656_e(100);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (I18n.func_188566_a((String)(this.func_77658_a() + ".info"))) {
            tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".info"), (Object[])new Object[0]));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        RayTraceResult hit = RayTraceHelper.rayTraceForRiftTools(world, player);
        if (world.field_72995_K) {
            if (!RayTraceHelper.isFloatingRift(hit, world)) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tools.rift_miss", new Object[0]), true);
                TileEntityFloatingRiftRenderer.showRiftCoreUntil = System.currentTimeMillis() + (long)ModConfig.graphics.highlightRiftCoreFor;
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (RayTraceHelper.isFloatingRift(hit, world)) {
            TileEntityFloatingRift rift = (TileEntityFloatingRift)world.func_175625_s(hit.func_178782_a());
            if (!rift.closing) {
                rift.setClosing(true);
                world.func_184133_a(null, player.func_180425_c(), ModSounds.RIFT_CLOSE, SoundCategory.BLOCKS, 0.6f, 1.0f);
                stack.func_77972_a(10, (EntityLivingBase)player);
                player.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".closing", new Object[0]), true);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".already_closing", new Object[0]), true);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }
}

