/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared.items;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.TeleportUtils;
import org.dimdev.dimdoors.client.TileEntityFloatingRiftRenderer;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.items.ModCreativeTabs;
import org.dimdev.dimdoors.shared.items.ModItems;
import org.dimdev.dimdoors.shared.items.RayTraceHelper;
import org.dimdev.dimdoors.shared.tileentities.TileEntityRift;

public class ItemRiftBlade
extends ItemSword {
    public static final String ID = "rift_blade";

    public ItemRiftBlade() {
        super(Item.ToolMaterial.IRON);
        this.func_77637_a(ModCreativeTabs.DIMENSIONAL_DOORS_CREATIVE_TAB);
        this.func_77655_b(ID);
        this.setRegistryName(new ResourceLocation("dimdoors", ID));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return ModItems.STABLE_FABRIC == repair.func_77973_b();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        RayTraceResult hit = RayTraceHelper.rayTraceEntity(world, player, 16.0, 1.0f);
        if (hit == null) {
            hit = RayTraceHelper.rayTraceForRiftTools(world, player);
        }
        if (world.field_72995_K) {
            if (RayTraceHelper.isLivingEntity(hit) || RayTraceHelper.isRift(hit, world)) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            player.func_146105_b((ITextComponent)new TextComponentTranslation(this.func_77658_a() + ".rift_miss", new Object[0]), true);
            TileEntityFloatingRiftRenderer.showRiftCoreUntil = System.currentTimeMillis() + (long)ModConfig.graphics.highlightRiftCoreFor;
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (RayTraceHelper.isLivingEntity(hit)) {
            double damageMultiplier = (double)stack.func_77952_i() / (double)stack.func_77958_k();
            double offsetDistance = Math.random() * damageMultiplier * 7.0 + 2.0;
            double offsetRotationYaw = (Math.random() - 0.5) * damageMultiplier * 360.0;
            Vec3d playerVec = player.func_174791_d();
            Vec3d entityVec = hit.field_72307_f;
            Vec3d offsetDirection = playerVec.func_178788_d(entityVec).func_72432_b();
            offsetDirection = offsetDirection.func_178785_b((float)(offsetRotationYaw * Math.PI) / 180.0f);
            BlockPos tpPos = new BlockPos(entityVec.func_178787_e(offsetDirection.func_186678_a(offsetDistance)));
            while (world.func_180495_p(tpPos).func_185904_a().func_76230_c()) {
                tpPos = tpPos.func_177984_a();
            }
            TeleportUtils.teleport((Entity)player, new Location(world, tpPos), (player.field_70177_z - (float)offsetRotationYaw) % 360.0f, player.field_70125_A);
            stack.func_77972_a(1, (EntityLivingBase)player);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (RayTraceHelper.isRift(hit, world)) {
            TileEntityRift rift = (TileEntityRift)world.func_175625_s(hit.func_178782_a());
            rift.teleport((Entity)player);
            stack.func_77972_a(1, (EntityLivingBase)player);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".info"), (Object[])new Object[0]));
    }
}

