/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.blocks.ModBlocks;
import org.dimdev.dimdoors.shared.items.ModItems;

public final class ModRecipes {
    public static ResourceLocation getNameForRecipe(ItemStack output) {
        ResourceLocation baseLoc;
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation("dimdoors", output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation("dimdoors", baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }

    public static IRecipe makeShapedRecipe(ItemStack output, Object ... params) {
        ResourceLocation location = ModRecipes.getNameForRecipe(output);
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
        ShapedRecipes recipe = new ShapedRecipes(output.func_77973_b().getRegistryName().toString(), primer.width, primer.height, primer.input, output);
        recipe.setRegistryName(location);
        return recipe;
    }

    public static IRecipe makeShapedOreRecipe(ItemStack output, Object ... params) {
        ResourceLocation location = ModRecipes.getNameForRecipe(output);
        ShapedOreRecipe recipe = new ShapedOreRecipe(location, output, params);
        recipe.setRegistryName(location);
        return recipe;
    }

    public static IRecipe makeShapedlessRecipe(ItemStack output, Object ... params) {
        ResourceLocation location = ModRecipes.getNameForRecipe(output);
        NonNullList ingredients = NonNullList.func_191196_a();
        for (Object obj : params) {
            ingredients.add((Object)CraftingHelper.getIngredient((Object)obj));
        }
        ShapelessRecipes recipe = new ShapelessRecipes(output.func_77973_b().getRegistryName().toString(), output, ingredients);
        recipe.setRegistryName(location);
        return recipe;
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        Item usedItem = ModConfig.general.useEnderPearlsInCrafting ? Items.field_151079_bi : ModItems.STABLE_FABRIC;
        IForgeRegistry registry = event.getRegistry();
        if (!ModConfig.general.useEnderPearlsInCrafting) {
            registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack(ModItems.STABLE_FABRIC), "yxy", Character.valueOf('x'), Items.field_151079_bi, Character.valueOf('y'), ModItems.WORLD_THREAD));
        }
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.IRON_DIMENSIONAL_DOOR), "yxy", Character.valueOf('x'), usedItem, Character.valueOf('y'), Items.field_151139_aw));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.UNSTABLE_DIMENSIONAL_DOOR), "xyx", Character.valueOf('x'), Items.field_151061_bv, Character.valueOf('y'), Items.field_151139_aw));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.WOOD_DIMENSIONAL_DOOR), "yxy", Character.valueOf('x'), usedItem, Character.valueOf('y'), Items.field_179570_aq));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Block)ModBlocks.WOOD_DIMENSIONAL_TRAPDOOR), "yx", Character.valueOf('x'), usedItem, Character.valueOf('y'), Blocks.field_150415_aT));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.GOLD_DIMENSIONAL_DOOR), new Object[]{"yxy", Character.valueOf('x'), usedItem, Character.valueOf('y'), ModItems.GOLD_DOOR}));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.GOLD_DOOR), "yy", "yy", "yy", Character.valueOf('y'), Items.field_151043_k));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.QUARTZ_DIMENSIONAL_DOOR), new Object[]{"yx", Character.valueOf('x'), usedItem, Character.valueOf('y'), ModItems.QUARTZ_DOOR}));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.QUARTZ_DOOR), "yy", "yy", "yy", Character.valueOf('y'), Items.field_151128_bU));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.RIFT_BLADE), "y", "y", "x", Character.valueOf('y'), usedItem, Character.valueOf('x'), Items.field_151040_l));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.RIFT_REMOVER), "xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151043_k, Character.valueOf('y'), usedItem));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.RIFT_REMOVER), "x x", " y ", "x x", Character.valueOf('x'), Items.field_151043_k, Character.valueOf('y'), usedItem));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.RIFT_SIGNATURE), "xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151042_j, Character.valueOf('y'), usedItem));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.RIFT_SIGNATURE), "x x", " y ", "x x", Character.valueOf('x'), Items.field_151042_j, Character.valueOf('y'), usedItem));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.STABILIZED_RIFT_SIGNATURE), new Object[]{"x x", " y ", "x x", Character.valueOf('x'), usedItem, Character.valueOf('y'), ModItems.RIFT_SIGNATURE}));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.RIFT_STABILIZER), "x x", " y ", "x x", Character.valueOf('x'), Items.field_151045_i, Character.valueOf('y'), usedItem));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.WOVEN_WORLD_THREAD_HELMET), "xxx", "x x", Character.valueOf('x'), ModItems.WORLD_THREAD));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.WOVEN_WORLD_THREAD_CHESTPLATE), "x x", "xxx", "xxx", Character.valueOf('x'), ModItems.WORLD_THREAD));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.WOVEN_WORLD_THREAD_LEGGINGS), "xxx", "x x", "x x", Character.valueOf('x'), ModItems.WORLD_THREAD));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.WOVEN_WORLD_THREAD_BOOTS), "x x", "x x", Character.valueOf('x'), ModItems.WORLD_THREAD));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.WOVEN_WORLD_THREAD_HELMET), "xyx", "x x", Character.valueOf('x'), ModItems.WORLD_THREAD, Character.valueOf('y'), Items.field_151024_Q));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.WOVEN_WORLD_THREAD_CHESTPLATE), "x x", "xyx", "x x", Character.valueOf('x'), ModItems.WORLD_THREAD, Character.valueOf('y'), Items.field_151027_R));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.WOVEN_WORLD_THREAD_LEGGINGS), "xyx", "x x", "x x", Character.valueOf('x'), ModItems.WORLD_THREAD, Character.valueOf('y'), Items.field_151026_S));
        registry.register((IForgeRegistryEntry)ModRecipes.makeShapedRecipe(new ItemStack((Item)ModItems.WOVEN_WORLD_THREAD_BOOTS), " y ", "x x", Character.valueOf('x'), ModItems.WORLD_THREAD, Character.valueOf('y'), Items.field_151021_T));
        for (int meta = 0; meta <= 15; ++meta) {
            registry.register((IForgeRegistryEntry)ModRecipes.makeShapedlessRecipe(new ItemStack((Item)ModItems.FABRIC, 1, meta), ModItems.FABRIC, new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.func_176766_a((int)meta).func_176765_a())));
        }
    }
}

