/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.dimdev.dimdoors.shared.world.RiftDecay;
import org.dimdev.dimdoors.shared.world.limbo.LimboDecay;

@Config(modid="dimdoors", name="dimdoors", category="")
public final class ModConfig {
    public static General general = new General();
    public static Rifts rifts = new Rifts();
    public static Pockets pockets = new Pockets();
    public static World world = new World();
    public static Dungeons dungeons = new Dungeons();
    public static Monoliths monoliths = new Monoliths();
    public static Limbo limbo = new Limbo();
    public static Graphics graphics = new Graphics();

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("dimdoors")) {
            ConfigManager.sync((String)event.getModID(), (Config.Type)Config.Type.INSTANCE);
            LimboDecay.blocksImmuneToDecay = null;
            RiftDecay.blocksImmuneToDecay = null;
        }
    }

    public static class Graphics {
        @Config.Name(value="showRiftCore")
        @Config.LangKey(value="dimdoors.graphics.showRiftCore")
        public boolean showRiftCore = false;
        @Config.Name(value="highlightRiftCoreFor")
        @Config.LangKey(value="dimdoors.graphics.highlightRiftCoreFor")
        @Config.RangeInt(min=-1)
        public int highlightRiftCoreFor = 15000;
        @Config.Name(value="riftSize")
        @Config.LangKey(value="dimdoors.graphics.riftSize")
        @Config.RangeDouble(min=0.0)
        public double riftSize = 1.0;
        @Config.Name(value="riftJitter")
        @Config.LangKey(value="dimdoors.graphics.riftJitter")
        @Config.RangeDouble(min=0.0)
        public double riftJitter = 1.0;
    }

    public static class Limbo {
        @Config.Name(value="universalLimbo")
        @Config.LangKey(value="dimdoors.limbo.universalLimbo")
        public boolean universalLimbo = false;
        @Config.Name(value="hardcoreLimbo")
        @Config.LangKey(value="dimdoors.limbo.hardcoreLimbo")
        public boolean hardcoreLimbo = false;
        @Config.Name(value="enableLimboDecay")
        @Config.LangKey(value="dimdoors.limbo.enableLimboDecay")
        public boolean enableLimboDecay = true;
        @Config.Name(value="blockLimboDecayBlackList")
        @Config.LangKey(value="dimdoors.limbo.blockLimboDecayBlackList")
        public String[] blockDecayLimboBlackList = new String[0];
    }

    public static class Monoliths {
        @Config.Name(value="dangerousLimboMonoliths")
        @Config.LangKey(value="dimdoors.monoliths.dangerousLimboMonoliths")
        public boolean dangerousLimboMonoliths = false;
        @Config.Name(value="monolithTeleportation")
        @Config.LangKey(value="dimdoors.monoliths.monolithTeleportation")
        public boolean monolithTeleportation = true;
    }

    public static class Dungeons {
        @Config.Name(value="maxDungeonDepth")
        @Config.LangKey(value="dimdoors.dungeons.maxDungeonDepth")
        @Config.RangeInt(min=5)
        public int maxDungeonDepth = 50;
    }

    public static class World {
        @Config.Name(value="clusterGenChance")
        @Config.LangKey(value="dimdoors.world.clusterGenChance")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double clusterGenChance = 2.0E-4;
        @Config.Name(value="gatewayGenChance")
        @Config.LangKey(value="dimdoors.world.gatewayGenChance")
        @Config.RangeDouble(min=0.0, max=1.0)
        public double gatewayGenChance = 0.0015;
        @Config.Name(value="clusterDimBlacklist")
        @Config.LangKey(value="dimdoors.world.clusterDimBlacklist")
        public int[] clusterDimBlacklist = new int[0];
        @Config.Name(value="gatewayDimBlacklist")
        @Config.LangKey(value="dimdoors.world.gatewayDimBlacklist")
        public int[] gatewayDimBlacklist = new int[0];
    }

    public static class Pockets {
        @Config.Name(value="pocketGridSize")
        @Config.LangKey(value="dimdoors.pockets.pocketGridSize")
        @Config.RangeInt(min=4)
        public int pocketGridSize = 32;
        @Config.Name(value="maxPocketSize")
        @Config.LangKey(value="dimdoors.pockets.maxPocketSize")
        @Config.RangeInt(min=0)
        public int maxPocketSize = 15;
        @Config.Name(value="privatePocketSize")
        @Config.LangKey(value="dimdoors.pockets.privatePocketSize")
        @Config.RangeInt(min=0, max=7)
        public int privatePocketSize = 2;
        @Config.Name(value="publicPocketSize")
        @Config.LangKey(value="dimdoors.pockets.publicPocketSize")
        @Config.RangeInt(min=0)
        public int publicPocketSize = 1;
        @Config.Name(value="loadAllSchematics")
        @Config.LangKey(value="dimdoors.pockets.loadAllSchematics")
        public boolean loadAllSchematics = false;
        @Config.Name(value="cachedSchematics")
        @Config.LangKey(value="dimdoors.pockets.cachedSchematics")
        public int cachedSchematics = 10;
    }

    public static class Rifts {
        @Config.Name(value="riftBoundingBoxInCreative")
        @Config.LangKey(value="dimdoors.general.riftBoundingBoxInCreative")
        public boolean riftBoundingBoxInCreative;
        @Config.Name(value="riftCloseSpeed")
        @Config.LangKey(value="dimdoors.general.riftCloseSpeed")
        @Config.RangeDouble(min=0.0)
        public float riftCloseSpeed = 1.0f;
        @Config.Name(value="enableRiftDecay")
        @Config.LangKey(value="dimdoors.world.enableDecay")
        public boolean enableRiftDecay = true;
        @Config.Name(value="blockRiftDecayBlackList")
        @Config.LangKey(value="dimdoors.world.blockDecayBlackList")
        public String[] blockRiftDecayBlackList = new String[0];
        @Config.Name(value="enableRiftDecayDropsWorldThread")
        @Config.LangKey(value="dimdoors.world.enableDecayDrops")
        public boolean enableRiftDecayDropsWorldThread = true;
        @Config.Name(value="maxRiftSize")
        @Config.LangKey(value="dimdoors.world.maxRiftSize")
        public int maxRiftSize = -1;
        @Config.Name(value="enableRifts")
        @Config.LangKey(value="dimdoors.world.enableRifts")
        public boolean enableRifts = true;
    }

    public static class General {
        @Config.Name(value="baseDimensionID")
        @Config.LangKey(value="dimdoors.general.baseDimensionID")
        @Config.RequiresWorldRestart
        public int baseDimensionID = 684;
        @Config.Name(value="useStatusBar")
        @Config.LangKey(value="dimdoors.general.useStatusBar")
        public boolean useStatusBar = true;
        @Config.Name(value="closeDoorBehind")
        @Config.LangKey(value="dimdoors.general.closeDoorBehind")
        public boolean closeDoorBehind = true;
        @Config.Name(value="teleportOffset")
        @Config.LangKey(value="dimdoors.general.teleportOffset")
        @Config.RangeDouble(min=0.0, max=3.0)
        public double teleportOffset = 0.5;
        @Config.Name(value="depthSpreadFactor")
        @Config.LangKey(value="dimdoors.general.depthSpreadFactor")
        public int depthSpreadFactor = 20;
        @Config.Name(value="useEnderPearlsInCrafting")
        @Config.LangKey(value="dimdoors.general.useEnderPearlsInCrafting")
        public boolean useEnderPearlsInCrafting = false;
    }
}

