/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.dimdoors.shared;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.dimdev.ddutils.TeleportUtils;
import org.dimdev.dimdoors.shared.ModConfig;
import org.dimdev.dimdoors.shared.rifts.registry.RiftRegistry;
import org.dimdev.dimdoors.shared.sound.ModSounds;
import org.dimdev.dimdoors.shared.world.ModDimensions;

public final class EventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getEntity();
        if (entity.field_71093_bK == ModDimensions.getLimboDim() && event.getSource() == DamageSource.field_76379_h) {
            event.setCanceled(true);
        } else if (entity instanceof EntityPlayer && ModDimensions.isDimDoorsDimension(entity.field_71093_bK) && event.getSource() == DamageSource.field_76380_i) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer && (ModDimensions.isDimDoorsDimension(entity.field_71093_bK) || ModConfig.limbo.universalLimbo)) {
            EntityPlayer player = (EntityPlayer)entity;
            player.func_70066_B();
            if (!player.func_70651_bq().isEmpty()) {
                player.func_70674_bp();
            }
            player.func_70606_j(entity.func_110138_aP());
            player.func_71024_bL().func_75114_a(20);
            player.func_71024_bL().func_75119_b(6.0f);
            EventHandler.teleportToLimbo(player);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!ModDimensions.isDimDoorsPocketDimension(event.fromDim) && ModDimensions.isDimDoorsPocketDimension(event.toDim)) {
            RiftRegistry.instance().setOverworldRift(event.player.func_110124_au(), null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (ModDimensions.isDimDoorsDimension(player.field_71093_bK) && player.field_70163_u < -50.0) {
            EventHandler.teleportToLimbo(player);
        }
    }

    private static void teleportToLimbo(EntityPlayer player) {
        double x = player.field_70165_t + MathHelper.func_151237_a((double)player.field_70170_p.field_73012_v.nextDouble(), (double)100.0, (double)100.0);
        double z = player.field_70161_v + MathHelper.func_151237_a((double)player.field_70170_p.field_73012_v.nextDouble(), (double)-100.0, (double)100.0);
        TeleportUtils.teleport((Entity)player, ModDimensions.getLimboDim(), x, 700.0, z, player.field_70177_z, player.field_70125_A);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.CRACK, SoundCategory.HOSTILE, 13.0f, 1.0f);
    }
}

