/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.ddutils.schem;

import cubicchunks.world.ICubicWorld;
import cubicchunks.world.cube.Cube;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.dimdev.dimdoors.DimDoors;

public class Schematic {
    private static final boolean cubicChunks = Loader.isModLoaded((String)"cubicchunks");
    public int version = 1;
    public String author = null;
    public String name = null;
    public long creationDate;
    public String[] requiredMods = new String[0];
    public short width;
    public short height;
    public short length;
    public int[] offset = new int[]{0, 0, 0};
    public int paletteMax = -1;
    public List<IBlockState> palette = new ArrayList<IBlockState>();
    public short[][][] blockData;
    public List<NBTTagCompound> tileEntities = new ArrayList<NBTTagCompound>();
    public List<NBTTagCompound> entities = new ArrayList<NBTTagCompound>();

    public Schematic() {
    }

    public Schematic(short width, short height, short length) {
        this();
        this.width = width;
        this.height = height;
        this.length = length;
        this.blockData = new short[width][height][length];
        this.palette.add(Blocks.field_150350_a.func_176223_P());
        ++this.paletteMax;
        this.creationDate = System.currentTimeMillis();
    }

    public Schematic(String name, String author, short width, short height, short length) {
        this(width, height, length);
        this.name = name;
        this.author = author;
    }

    public static Schematic loadFromNBT(NBTTagCompound nbt) {
        int i;
        Schematic schematic = new Schematic();
        schematic.version = nbt.func_74762_e("Version");
        schematic.creationDate = System.currentTimeMillis();
        if (nbt.func_74764_b("Metadata")) {
            NBTTagCompound metadataCompound = nbt.func_74775_l("Metadata").func_74775_l(".");
            if (nbt.func_74764_b("Author")) {
                schematic.author = metadataCompound.func_74779_i("Author");
            }
            schematic.name = metadataCompound.func_74779_i("Name");
            schematic.creationDate = nbt.func_74764_b("Date") ? metadataCompound.func_74763_f("Date") : -1L;
            if (nbt.func_74764_b("RequiredMods")) {
                NBTTagList requiredModsTagList = (NBTTagList)metadataCompound.func_74781_a("RequiredMods");
                schematic.requiredMods = new String[requiredModsTagList.func_74745_c()];
                for (int i2 = 0; i2 < requiredModsTagList.func_74745_c(); ++i2) {
                    schematic.requiredMods[i2] = requiredModsTagList.func_150307_f(i2);
                }
            }
        }
        schematic.width = nbt.func_74765_d("Width");
        schematic.height = nbt.func_74765_d("Height");
        schematic.length = nbt.func_74765_d("Length");
        if (nbt.func_74764_b("Offset")) {
            schematic.offset = nbt.func_74759_k("Offset");
        }
        NBTTagCompound paletteNBT = nbt.func_74775_l("Palette");
        HashMap<Integer, String> paletteMap = new HashMap<Integer, String>();
        for (String key : paletteNBT.func_150296_c()) {
            int paletteID = paletteNBT.func_74762_e(key);
            paletteMap.put(paletteID, key);
        }
        for (int i3 = 0; i3 < paletteMap.size(); ++i3) {
            String stateString;
            String blockString;
            String blockStateString = (String)paletteMap.get(i3);
            char lastBlockStateStringChar = blockStateString.charAt(blockStateString.length() - 1);
            if (lastBlockStateStringChar == ']') {
                String[] blockAndStateStrings = blockStateString.split("\\[");
                blockString = blockAndStateStrings[0];
                stateString = blockAndStateStrings[1];
                stateString = stateString.substring(0, stateString.length() - 1);
            } else {
                blockString = blockStateString;
                stateString = "";
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockString));
            IBlockState blockstate = block.func_176223_P();
            if (!stateString.equals("")) {
                String[] properties = stateString.split(",");
                blockstate = Schematic.getBlockStateWithProperties(block, properties);
            }
            schematic.palette.add(blockstate);
        }
        schematic.paletteMax = nbt.func_74764_b("PaletteMax") ? nbt.func_74762_e("PaletteMax") : schematic.palette.size() - 1;
        byte[] blockDataIntArray = nbt.func_74770_j("BlockData");
        schematic.blockData = new short[schematic.width][schematic.height][schematic.length];
        for (int x = 0; x < schematic.width; ++x) {
            for (int y = 0; y < schematic.height; ++y) {
                for (int z = 0; z < schematic.length; ++z) {
                    schematic.blockData[x][y][z] = blockDataIntArray[x + z * schematic.width + y * schematic.width * schematic.length];
                }
            }
        }
        if (nbt.func_74764_b("TileEntities")) {
            NBTTagList tileEntitiesTagList = (NBTTagList)nbt.func_74781_a("TileEntities");
            for (i = 0; i < tileEntitiesTagList.func_74745_c(); ++i) {
                NBTTagCompound tileEntityTagCompound = tileEntitiesTagList.func_150305_b(i);
                schematic.tileEntities.add(tileEntityTagCompound);
            }
        }
        if (nbt.func_74764_b("Entities")) {
            NBTTagList entitiesTagList = (NBTTagList)nbt.func_74781_a("Entities");
            for (i = 0; i < entitiesTagList.func_74745_c(); ++i) {
                NBTTagCompound entityTagCompound = entitiesTagList.func_150305_b(i);
                schematic.entities.add(entityTagCompound);
            }
        }
        return schematic;
    }

    public NBTTagCompound saveToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("Version", this.version);
        NBTTagCompound metadataCompound = new NBTTagCompound();
        if (this.author != null) {
            metadataCompound.func_74778_a("Author", this.author);
        }
        metadataCompound.func_74778_a("Name", this.name);
        if (this.creationDate != -1L) {
            metadataCompound.func_74772_a("Date", this.creationDate);
        }
        NBTTagList requiredModsTagList = new NBTTagList();
        for (String requiredMod : this.requiredMods) {
            requiredModsTagList.func_74742_a((NBTBase)new NBTTagString(requiredMod));
        }
        metadataCompound.func_74782_a("RequiredMods", (NBTBase)requiredModsTagList);
        nbt.func_74782_a("Metadata", (NBTBase)metadataCompound);
        nbt.func_74777_a("Width", this.width);
        nbt.func_74777_a("Height", this.height);
        nbt.func_74777_a("Length", this.length);
        nbt.func_74783_a("Offset", this.offset);
        nbt.func_74768_a("PaletteMax", this.paletteMax);
        NBTTagCompound paletteNBT = new NBTTagCompound();
        for (int i = 0; i < this.palette.size(); ++i) {
            IBlockState state = this.palette.get(i);
            String blockStateString = Schematic.getBlockStateStringFromState(state);
            paletteNBT.func_74768_a(blockStateString, i);
        }
        nbt.func_74782_a("Palette", (NBTBase)paletteNBT);
        byte[] blockDataIntArray = new byte[this.width * this.height * this.length];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                for (int z = 0; z < this.length; ++z) {
                    blockDataIntArray[x + z * this.width + y * this.width * this.length] = (byte)this.blockData[x][y][z];
                }
            }
        }
        nbt.func_74773_a("BlockData", blockDataIntArray);
        NBTTagList tileEntitiesTagList = new NBTTagList();
        for (NBTTagCompound tileEntityTagCompound : this.tileEntities) {
            tileEntitiesTagList.func_74742_a((NBTBase)tileEntityTagCompound);
        }
        nbt.func_74782_a("TileEntities", (NBTBase)tileEntitiesTagList);
        NBTTagList entitiesTagList = new NBTTagList();
        for (NBTTagCompound entityTagCompound : this.entities) {
            entitiesTagList.func_74742_a((NBTBase)entityTagCompound);
        }
        nbt.func_74782_a("Entities", (NBTBase)entitiesTagList);
        return nbt;
    }

    static IBlockState getBlockStateWithProperties(Block block, String[] properties) {
        HashMap<String, String> propertyAndBlockStringsMap = new HashMap<String, String>();
        for (String property : properties) {
            String[] propertyAndBlockStrings = property.split("=");
            propertyAndBlockStringsMap.put(propertyAndBlockStrings[0], propertyAndBlockStrings[1]);
        }
        BlockStateContainer container = block.func_176194_O();
        IBlockState chosenState = block.func_176223_P();
        for (Map.Entry entry : propertyAndBlockStringsMap.entrySet()) {
            IProperty property = container.func_185920_a((String)entry.getKey());
            if (property == null) continue;
            Comparable value = null;
            for (Comparable object : property.func_177700_c()) {
                if (!object.toString().equals(entry.getValue())) continue;
                value = object;
                break;
            }
            if (value == null) continue;
            chosenState = chosenState.func_177226_a(property, value);
        }
        return chosenState;
    }

    private static String getBlockStateStringFromState(IBlockState state) {
        String totalString;
        Block block = state.func_177230_c();
        String blockNameString = String.valueOf(Block.field_149771_c.func_177774_c((Object)block));
        StringBuilder blockStateString = new StringBuilder();
        IBlockState defaultState = block.func_176223_P();
        if (state == defaultState) {
            totalString = blockNameString;
        } else {
            BlockStateContainer container = block.func_176194_O();
            for (IProperty property : container.func_177623_d()) {
                String thisPropertyValue;
                String defaultPropertyValue = ((Comparable)defaultState.func_177228_b().get((Object)property)).toString();
                if (defaultPropertyValue.equals(thisPropertyValue = ((Comparable)state.func_177228_b().get((Object)property)).toString())) continue;
                String firstHalf = property.func_177701_a();
                String secondHalf = ((Comparable)state.func_177228_b().get((Object)property)).toString();
                String propertyString = firstHalf + "=" + secondHalf;
                blockStateString.append(propertyString).append(",");
            }
            blockStateString = new StringBuilder(blockStateString.substring(0, blockStateString.length() - 1));
            totalString = blockNameString + "[" + blockStateString + "]";
        }
        return totalString;
    }

    public static Schematic createFromWorld(World world, BlockPos from, BlockPos to) {
        BlockPos dimensions = to.func_177973_b((Vec3i)from).func_177982_a(1, 1, 1);
        Schematic schematic = new Schematic((short)dimensions.func_177958_n(), (short)dimensions.func_177956_o(), (short)dimensions.func_177952_p());
        HashSet<String> mods = new HashSet<String>();
        for (int x = 0; x < dimensions.func_177958_n(); ++x) {
            for (int y = 0; y < dimensions.func_177956_o(); ++y) {
                for (int z = 0; z < dimensions.func_177952_p(); ++z) {
                    BlockPos pos = new BlockPos(from.func_177958_n() + x, from.func_177956_o() + y, from.func_177952_p() + z);
                    IBlockState state = world.func_180495_p(pos);
                    String id = Schematic.getBlockStateStringFromState(state);
                    if (id.contains(":")) {
                        mods.add(id.split(":")[0]);
                    }
                    schematic.setBlockState(x, y, z, state);
                    TileEntity tileEntity = world.func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
                    if (tileEntity == null) continue;
                    NBTTagCompound tileEntityNBT = tileEntity.serializeNBT();
                    tileEntityNBT.func_74768_a("x", tileEntityNBT.func_74762_e("x") - from.func_177958_n());
                    tileEntityNBT.func_74768_a("y", tileEntityNBT.func_74762_e("y") - from.func_177956_o());
                    tileEntityNBT.func_74768_a("z", tileEntityNBT.func_74762_e("z") - from.func_177952_p());
                    schematic.tileEntities.add(tileEntityNBT);
                }
            }
        }
        for (Entity entity2 : world.func_175674_a(null, Schematic.getBoundingBox((Vec3i)from, (Vec3i)to), entity -> !(entity instanceof EntityPlayerMP))) {
            NBTTagCompound entityNBT = entity2.serializeNBT();
            NBTTagList posNBT = (NBTTagList)entityNBT.func_74781_a("Pos");
            NBTTagList newPosNBT = new NBTTagList();
            newPosNBT.func_74742_a((NBTBase)new NBTTagDouble(posNBT.func_150309_d(0) - (double)from.func_177958_n()));
            newPosNBT.func_74742_a((NBTBase)new NBTTagDouble(posNBT.func_150309_d(1) - (double)from.func_177956_o()));
            newPosNBT.func_74742_a((NBTBase)new NBTTagDouble(posNBT.func_150309_d(2) - (double)from.func_177952_p()));
            entityNBT.func_74782_a("Pos", (NBTBase)newPosNBT);
            schematic.entities.add(entityNBT);
        }
        schematic.requiredMods = mods.toArray(new String[mods.size()]);
        schematic.creationDate = System.currentTimeMillis();
        return schematic;
    }

    private static AxisAlignedBB getBoundingBox(Vec3i from, Vec3i to) {
        return new AxisAlignedBB(new BlockPos(from.func_177958_n(), from.func_177956_o(), from.func_177952_p()), new BlockPos(to.func_177958_n(), to.func_177956_o(), to.func_177952_p()));
    }

    public void place(World world, int xBase, int yBase, int zBase) {
        this.setBlocks(world, xBase, yBase, zBase);
        for (NBTTagCompound tileEntityNBT : this.tileEntities) {
            BlockPos schematicPos = new BlockPos(tileEntityNBT.func_74762_e("x"), tileEntityNBT.func_74762_e("y"), tileEntityNBT.func_74762_e("z"));
            BlockPos pos = new BlockPos(xBase, yBase, zBase).func_177971_a((Vec3i)schematicPos);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity != null) {
                String blockTileEntityId;
                String schematicTileEntityId = tileEntityNBT.func_74779_i("id");
                if (schematicTileEntityId.equals(blockTileEntityId = TileEntity.func_190559_a(tileEntity.getClass()).toString())) {
                    tileEntity.func_145839_a(tileEntityNBT);
                    tileEntity.func_145834_a(world);
                    tileEntity.func_174878_a(pos);
                    tileEntity.func_70296_d();
                    continue;
                }
                throw new RuntimeException("Schematic contained TileEntity " + schematicTileEntityId + " at " + pos + " but the TileEntity of that block (" + world.func_180495_p(pos) + ") must be " + blockTileEntityId);
            }
            throw new RuntimeException("Schematic contained TileEntity info at " + pos + " but the block there (" + world.func_180495_p(pos) + ") has no TileEntity.");
        }
        for (NBTTagCompound entityNBT : this.entities) {
            NBTTagList posNBT = (NBTTagList)entityNBT.func_74781_a("Pos");
            NBTTagList newPosNBT = new NBTTagList();
            newPosNBT.func_74742_a((NBTBase)new NBTTagDouble(posNBT.func_150309_d(0) + (double)xBase));
            newPosNBT.func_74742_a((NBTBase)new NBTTagDouble(posNBT.func_150309_d(1) + (double)yBase));
            newPosNBT.func_74742_a((NBTBase)new NBTTagDouble(posNBT.func_150309_d(2) + (double)zBase));
            NBTTagCompound adjustedEntityNBT = entityNBT.func_74737_b();
            adjustedEntityNBT.func_74782_a("Pos", (NBTBase)newPosNBT);
            adjustedEntityNBT.func_186854_a("UUID", UUID.randomUUID());
            Entity entity = EntityList.func_75615_a((NBTTagCompound)adjustedEntityNBT, (World)world);
            world.func_72838_d(entity);
        }
    }

    public IBlockState getBlockState(int x, int y, int z) {
        return this.palette.get(this.blockData[x][y][z]);
    }

    public void setBlockState(int x, int y, int z, IBlockState state) {
        if (this.palette.contains(state)) {
            this.blockData[x][y][z] = (short)this.palette.indexOf(state);
        } else {
            this.palette.add(state);
            this.blockData[x][y][z] = (short)(++this.paletteMax);
        }
    }

    private void setBlocks(World world, int xBase, int yBase, int zBase) {
        long setTime = 0L;
        long relightTime = 0L;
        if (cubicChunks && ((ICubicWorld)world).isCubicWorld()) {
            DimDoors.log.debug("Setting cube blockstates");
            ICubicWorld cubicWorld = (ICubicWorld)world;
            for (int cubeX = 0; cubeX <= (this.width >> 4) + 1; ++cubeX) {
                for (int cubeY = 0; cubeY <= (this.height >> 4) + 1; ++cubeY) {
                    for (int cubeZ = 0; cubeZ <= (this.length >> 4) + 1; ++cubeZ) {
                        long setStart = System.nanoTime();
                        Cube cube = cubicWorld.getCubeFromCubeCoords((xBase >> 4) + cubeX, (yBase >> 4) + cubeY, (zBase >> 4) + cubeZ);
                        ExtendedBlockStorage storage = cube.getStorage();
                        boolean setAir = storage != null;
                        for (int x = 0; x < 16; ++x) {
                            for (int y = 0; y < 16; ++y) {
                                for (int z = 0; z < 16; ++z) {
                                    int sx = (cubeX << 4) + x - (xBase & 0xF);
                                    int sy = (cubeY << 4) + y - (yBase & 0xF);
                                    int sz = (cubeZ << 4) + z - (zBase & 0xF);
                                    if (sx < 0 || sy < 0 || sz < 0 || sx >= this.width || sy >= this.height || sz >= this.length) continue;
                                    IBlockState state = this.palette.get(this.blockData[sx][sy][sz]);
                                    if (!state.func_177230_c().equals(Blocks.field_150350_a)) {
                                        if (storage == null) {
                                            storage = new ExtendedBlockStorage(cube.getY() << 4, world.field_73011_w.func_191066_m());
                                            cube.setStorage(storage);
                                        }
                                        storage.func_177484_a(x, y, z, state);
                                        continue;
                                    }
                                    if (!setAir) continue;
                                    storage.func_177484_a(x, y, z, state);
                                }
                            }
                        }
                        setTime += System.nanoTime() - setStart;
                        long relightStart = System.nanoTime();
                        cube.setInitialLightingDone(false);
                        relightTime += System.nanoTime() - relightStart;
                        cube.markDirty();
                    }
                }
            }
        } else {
            DimDoors.log.debug("Setting chunk blockstates");
            for (int chunkX = 0; chunkX <= (this.width >> 4) + 1; ++chunkX) {
                for (int chunkZ = 0; chunkZ <= (this.length >> 4) + 1; ++chunkZ) {
                    long setStart = System.nanoTime();
                    Chunk chunk = world.func_72964_e((xBase >> 4) + chunkX, (zBase >> 4) + chunkZ);
                    ExtendedBlockStorage[] storageArray = chunk.func_76587_i();
                    for (int storageY = 0; storageY <= (this.height >> 4) + 1; ++storageY) {
                        ExtendedBlockStorage storage = storageArray[(yBase >> 4) + storageY];
                        boolean setAir = storage != null;
                        for (int x = 0; x < 16; ++x) {
                            for (int y = 0; y < 16; ++y) {
                                for (int z = 0; z < 16; ++z) {
                                    int sx = (chunkX << 4) + x - (xBase & 0xF);
                                    int sy = (storageY << 4) + y - (yBase & 0xF);
                                    int sz = (chunkZ << 4) + z - (zBase & 0xF);
                                    if (sx < 0 || sy < 0 || sz < 0 || sx >= this.width || sy >= this.height || sz >= this.length) continue;
                                    IBlockState state = this.palette.get(this.blockData[sx][sy][sz]);
                                    if (!state.func_177230_c().equals(Blocks.field_150350_a)) {
                                        if (storage == null) {
                                            storageArray[(yBase >> 4) + storageY] = storage = new ExtendedBlockStorage((yBase >> 4) + storageY << 4, world.field_73011_w.func_191066_m());
                                        }
                                        storage.func_177484_a(x, y, z, state);
                                        continue;
                                    }
                                    if (!setAir) continue;
                                    storage.func_177484_a(x, y, z, state);
                                }
                            }
                        }
                    }
                    setTime += System.nanoTime() - setStart;
                    long relightStart = System.nanoTime();
                    chunk.func_177421_e(false);
                    chunk.func_177446_d(true);
                    chunk.func_76613_n();
                    chunk.func_150809_p();
                    relightTime += System.nanoTime() - relightStart;
                    chunk.func_76630_e();
                }
            }
        }
        world.func_147458_c(xBase, yBase, zBase, xBase + this.width, yBase + this.height, zBase + this.length);
        DimDoors.log.debug("Set block states in " + setTime / 1000000L + " ms and relit chunks/cubes in " + relightTime / 1000000L);
    }
}

