/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.ddutils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketPlayerAbilities;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;
import net.minecraft.world.WorldServer;
import net.minecraft.world.end.DragonFightManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.dimdev.ddutils.Location;
import org.dimdev.ddutils.MCPReflection;
import org.dimdev.ddutils.WorldUtils;

public final class TeleportUtils {
    private static final Field invulnerableDimensionChange;
    private static final Field thrower;
    private static final Field enteredNetherPosition;
    private static final Method captureCurrentPosition;
    private static final Method copyDataFromOld;
    private static final Method searchForOtherItemsNearby;
    private static final Method updateplayers;

    private static void setInvulnerableDimensionChange(EntityPlayerMP player, boolean value) {
        try {
            invulnerableDimensionChange.set(player, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setThrower(EntityThrowable entity, EntityLivingBase value) {
        try {
            thrower.set(entity, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setEnteredNetherPosition(EntityPlayerMP player, Vec3d value) {
        try {
            enteredNetherPosition.set(player, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void captureCurrentPosition(NetHandlerPlayServer connection) {
        try {
            captureCurrentPosition.invoke((Object)connection, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyDataFromOld(Entity newEntity, Entity oldEntity) {
        try {
            copyDataFromOld.invoke((Object)newEntity, oldEntity);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void searchForOtherItemsNearby(EntityItem item) {
        try {
            searchForOtherItemsNearby.invoke((Object)item, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void updateplayers(DragonFightManager dragonFightManager) {
        try {
            updateplayers.invoke((Object)dragonFightManager, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Entity teleport(Entity entity, Location location) {
        return TeleportUtils.teleport(entity, location, entity.field_70177_z, entity.field_70125_A);
    }

    public static Entity teleport(Entity entity, Location location, float yaw, float pitch) {
        return TeleportUtils.teleport(entity, location.dim, (double)location.getPos().func_177958_n() + 0.5, location.getPos().func_177956_o(), (double)location.getPos().func_177952_p() + 0.5, yaw, pitch);
    }

    public static Entity teleport(Entity entity, BlockPos pos, float yaw, float pitch) {
        return TeleportUtils.teleport(entity, WorldUtils.getDim(entity.func_130014_f_()), (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, yaw, pitch);
    }

    public static Entity teleport(Entity entity, double x, double y, double z, float yaw, float pitch) {
        return TeleportUtils.teleport(entity, WorldUtils.getDim(entity.func_130014_f_()), x, y, z, yaw, pitch);
    }

    public static Entity teleport(Entity entity, int newDimension, double x, double y, double z, float yaw, float pitch) {
        if (entity instanceof FakePlayer) {
            return entity;
        }
        if (entity.field_70170_p.field_72995_K || entity.field_70128_L) {
            return null;
        }
        yaw = MathHelper.func_76142_g((float)yaw);
        pitch = MathHelper.func_76142_g((float)pitch);
        entity.func_184210_p();
        entity.func_184226_ay();
        int oldDimension = entity.field_71093_bK;
        if (entity instanceof EntityPlayerMP) {
            entity.field_70145_X = true;
            TeleportUtils.setInvulnerableDimensionChange((EntityPlayerMP)entity, true);
        }
        if (oldDimension == newDimension) {
            if (entity instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)entity;
                player.field_71135_a.func_175089_a(x, y, z, yaw, pitch, EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class));
                TeleportUtils.captureCurrentPosition(player.field_71135_a);
            } else {
                entity.func_70012_b(x, y, z, yaw, pitch);
            }
            entity.func_70034_d(yaw);
            return entity;
        }
        MinecraftServer server = entity.func_184102_h();
        WorldServer oldWorld = server.func_71218_a(oldDimension);
        WorldServer newWorld = server.func_71218_a(newDimension);
        if (!ForgeHooks.onTravelToDimension((Entity)entity, (int)newDimension)) {
            return entity;
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (newDimension == -1) {
                TeleportUtils.setEnteredNetherPosition(player, new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));
            } else if (oldDimension != -1 && newDimension != 0) {
                TeleportUtils.setEnteredNetherPosition(player, null);
            }
            player.field_71093_bK = newDimension;
            player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(player.field_71093_bK, newWorld.func_175659_aa(), newWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            player.field_71133_b.func_184103_al().func_187243_f(player);
            oldWorld.func_72973_f((Entity)player);
            player.field_70128_L = false;
            oldWorld.field_72984_F.func_76320_a("moving");
            player.func_70012_b(x, y, z, yaw, pitch);
            if (entity.func_70089_S()) {
                oldWorld.func_72866_a(entity, false);
            }
            oldWorld.field_72984_F.func_76319_b();
            oldWorld.field_72984_F.func_76320_a("placing");
            newWorld.func_72838_d((Entity)player);
            newWorld.func_72866_a((Entity)player, false);
            oldWorld.field_72984_F.func_76319_b();
            player.func_70029_a((World)newWorld);
            player.field_71133_b.func_184103_al().func_72375_a(player, oldWorld);
            player.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            TeleportUtils.captureCurrentPosition(player.field_71135_a);
            player.field_71134_c.func_73080_a(newWorld);
            player.field_71135_a.func_147359_a((Packet)new SPacketPlayerAbilities(player.field_71075_bZ));
            player.field_71133_b.func_184103_al().func_72354_b(player, newWorld);
            player.field_71133_b.func_184103_al().func_72385_f(player);
            for (PotionEffect potioneffect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(player.func_145782_y(), potioneffect));
            }
            if (oldWorld.field_73011_w instanceof WorldProviderEnd) {
                DragonFightManager dragonFightManager = ((WorldProviderEnd)oldWorld.field_73011_w).func_186063_s();
                TeleportUtils.updateplayers(dragonFightManager);
            }
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, oldDimension, newDimension);
            return entity;
        }
        if (entity instanceof EntityMinecartContainer) {
            ((EntityMinecartContainer)entity).field_94112_b = false;
        }
        if (entity instanceof EntityEnderPearl) {
            TeleportUtils.setThrower((EntityThrowable)entity, null);
        }
        entity.field_70170_p.field_72984_F.func_76320_a("changeDimension");
        entity.field_71093_bK = newDimension;
        entity.field_70170_p.func_72900_e(entity);
        entity.field_70128_L = false;
        entity.field_70170_p.field_72984_F.func_76320_a("reposition");
        oldWorld.func_72866_a(entity, false);
        entity.field_70170_p.field_72984_F.func_76318_c("reloading");
        Entity newEntity = EntityList.func_191304_a(entity.getClass(), (World)newWorld);
        if (newEntity != null) {
            TeleportUtils.copyDataFromOld(newEntity, entity);
            newEntity.func_70080_a(x, y, z, yaw, pitch);
            boolean oldForceSpawn = newEntity.field_98038_p;
            newEntity.field_98038_p = true;
            newWorld.func_72838_d(newEntity);
            newEntity.field_98038_p = oldForceSpawn;
            newWorld.func_72866_a(newEntity, false);
        }
        entity.field_70128_L = true;
        entity.field_70170_p.field_72984_F.func_76319_b();
        oldWorld.func_82742_i();
        newWorld.func_82742_i();
        entity.field_70170_p.field_72984_F.func_76319_b();
        if (newEntity instanceof EntityItem) {
            TeleportUtils.searchForOtherItemsNearby((EntityItem)newEntity);
        }
        return newEntity;
    }

    static {
        try {
            invulnerableDimensionChange = MCPReflection.getMCPField(EntityPlayerMP.class, "invulnerableDimensionChange", "field_184851_cj");
            thrower = MCPReflection.getMCPField(EntityThrowable.class, "thrower", "field_70192_c");
            enteredNetherPosition = MCPReflection.getMCPField(EntityPlayerMP.class, "enteredNetherPosition", "field_193110_cw");
            captureCurrentPosition = MCPReflection.getMCPMethod(NetHandlerPlayServer.class, "captureCurrentPosition", "func_184342_d", new Class[0]);
            copyDataFromOld = MCPReflection.getMCPMethod(Entity.class, "copyDataFromOld", "func_180432_n", Entity.class);
            searchForOtherItemsNearby = MCPReflection.getMCPMethod(EntityItem.class, "searchForOtherItemsNearby", "func_85054_d", new Class[0]);
            updateplayers = MCPReflection.getMCPMethod(DragonFightManager.class, "updateplayers", "func_186100_j", new Class[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

