/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.ddutils;

import java.io.Serializable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.dimdev.ddutils.WorldUtils;

public final class Location
implements Serializable {
    public final int dim;
    public final BlockPos pos;

    public Location(World world, BlockPos pos) {
        this(world.field_73011_w.getDimension(), pos);
    }

    public Location(World world, int x, int y, int z) {
        this(world, new BlockPos(x, y, z));
    }

    public Location(int dim, int x, int y, int z) {
        this(dim, new BlockPos(x, y, z));
    }

    public Location(int dim, BlockPos pos) {
        this.dim = dim;
        this.pos = pos;
    }

    public int getX() {
        return this.pos.func_177958_n();
    }

    public int getY() {
        return this.pos.func_177956_o();
    }

    public int getZ() {
        return this.pos.func_177952_p();
    }

    public TileEntity getTileEntity() {
        return this.getWorld().func_175625_s(this.pos);
    }

    public IBlockState getBlockState() {
        return this.getWorld().func_180495_p(this.pos);
    }

    public WorldServer getWorld() {
        return WorldUtils.getWorld(this.dim);
    }

    public static Location getLocation(TileEntity tileEntity) {
        World world = tileEntity.func_145831_w();
        BlockPos blockPos = tileEntity.func_174877_v();
        return new Location(world, blockPos);
    }

    public static Location getLocation(Entity entity) {
        World world = entity.field_70170_p;
        BlockPos blockPos = entity.func_180425_c();
        return new Location(world, blockPos);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return other.dim == this.dim && other.pos.equals((Object)this.pos);
    }

    public int hashCode() {
        return this.pos.hashCode() * 31 + this.dim;
    }

    public int getDim() {
        return this.dim;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String toString() {
        return "Location(dim=" + this.getDim() + ", pos=" + this.getPos() + ")";
    }
}

