/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.block.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.util.EnchantmentUtils;
import net.darkhax.eplus.EnchLogic;
import net.darkhax.eplus.inventory.ItemStackHandlerEnchant;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EnchantmentLogicController {
    private final EntityPlayer player;
    private final World world;
    private final BlockPos pos;
    private final ItemStackHandlerEnchant inventory;
    private ItemStack inputStack;
    private List<Enchantment> validEnchantments;
    private Map<Enchantment, Integer> initialEnchantments;
    private Map<Enchantment, Integer> itemEnchantments;
    private float enchantmentPower;
    private int cost;

    public EnchantmentLogicController(EntityPlayer player, World world, BlockPos pos, ItemStackHandlerEnchant inventory) {
        this.player = player;
        this.world = world;
        this.pos = pos;
        this.inventory = inventory;
        this.validEnchantments = new ArrayList<Enchantment>();
        this.initialEnchantments = new HashMap<Enchantment, Integer>();
        this.itemEnchantments = new HashMap<Enchantment, Integer>();
        this.onItemUpdated();
    }

    public void onItemUpdated() {
        this.inputStack = this.inventory.getEnchantingStack();
        this.initialEnchantments = EnchantmentHelper.func_82781_a((ItemStack)this.inputStack);
        this.itemEnchantments = new HashMap<Enchantment, Integer>(this.initialEnchantments);
        this.validEnchantments = EnchLogic.getValidEnchantments(this.inputStack, this.world, this.getPos());
        this.calculateState();
    }

    public void calculateState() {
        this.enchantmentPower = EnchantmentUtils.getEnchantingPower((World)this.world, (BlockPos)this.pos);
        this.cost = 0;
        for (Map.Entry<Enchantment, Integer> newEntry : this.itemEnchantments.entrySet()) {
            int original = this.initialEnchantments.getOrDefault(newEntry.getKey(), 0);
            int newLevels = newEntry.getValue() - original;
            if (newLevels <= 0) continue;
            this.cost += EnchLogic.calculateNewEnchCost(newEntry.getKey(), newLevels);
        }
        for (Map.Entry<Enchantment, Integer> existingEnch : this.initialEnchantments.entrySet()) {
            int currentCurseLevel;
            if (!existingEnch.getKey().func_190936_d() || existingEnch.getValue() <= 0 || (currentCurseLevel = this.itemEnchantments.getOrDefault(existingEnch.getKey(), 0).intValue()) >= existingEnch.getValue()) continue;
            this.cost += EnchLogic.calculateNewEnchCost(existingEnch.getKey(), existingEnch.getValue() - currentCurseLevel);
        }
        if (this.enchantmentPower > 0.0f) {
            this.cost = (int)((float)this.cost - (float)this.getCost() * this.enchantmentPower / 100.0f);
        }
    }

    public int getCurrentLevel(Enchantment enchant) {
        return this.itemEnchantments.getOrDefault(enchant, 0);
    }

    public void updateEnchantment(Enchantment enchantment, int level) {
        if (level < 1) {
            this.itemEnchantments.remove(enchantment);
        } else if (this.validEnchantments.contains(enchantment)) {
            this.itemEnchantments.put(enchantment, level);
        }
        this.calculateState();
    }

    public boolean isValidEnchantment(Enchantment enchantment) {
        return this.validEnchantments.contains(enchantment);
    }

    public List<Enchantment> getValidEnchantments() {
        return this.validEnchantments;
    }

    public Map<Enchantment, Integer> getInitialEnchantments() {
        return this.initialEnchantments;
    }

    public Map<Enchantment, Integer> getCurrentEnchantments() {
        return this.itemEnchantments;
    }

    public void enchantItem() {
        if (!this.player.func_184812_l_() && EnchLogic.getExperience(this.player) < this.getCost()) {
            return;
        }
        if (!this.player.func_184812_l_() && this.cost > 0) {
            EnchLogic.removeExperience(this.player, this.getCost());
        }
        EnchantmentHelper.func_82782_a(new HashMap(), (ItemStack)this.inputStack);
        for (Map.Entry<Enchantment, Integer> entry : this.itemEnchantments.entrySet()) {
            if (entry.getValue() <= 0) continue;
            this.inputStack.func_77966_a(entry.getKey(), entry.getValue().intValue());
        }
        this.onItemUpdated();
    }

    public int getCost() {
        return this.cost;
    }

    public float getEnchantmentPower() {
        return Math.min(this.enchantmentPower, 30.0f);
    }

    public ItemStackHandlerEnchant getInventory() {
        return this.inventory;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public World getWorld() {
        return this.world;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }
}

