/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.eplus.block;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.block.ITileEntityBlock;
import net.darkhax.eplus.ConfigurationHandler;
import net.darkhax.eplus.block.tileentity.TileEntityDecoration;
import net.darkhax.eplus.block.tileentity.TileEntityWithBook;
import net.darkhax.eplus.block.tileentity.renderer.TileEntityDecorationRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBookDecoration
extends BlockContainer
implements ITileEntityBlock {
    private static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.3, 0.6, 0.3, 0.6, 0.9, 0.6);
    public static final String[] TYPES = new String[]{"eplus", "vanilla", "prismarine", "nether", "tartarite", "white", "metal"};

    public BlockBookDecoration() {
        super(Material.field_151575_d);
        this.func_149711_c(1.5f);
        this.func_149715_a(0.9375f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDecoration();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (source.func_175625_s(pos) instanceof TileEntityDecoration) {
            return BOUNDS.func_72317_d(0.0, (double)((TileEntityDecoration)source.func_175625_s((BlockPos)pos)).height, 0.0);
        }
        return BOUNDS;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return ConfigurationHandler.floatingBookBonus;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && !playerIn.func_184614_ca().func_190926_b() && worldIn.func_175625_s(pos) instanceof TileEntityDecoration) {
            TileEntityDecoration deco = (TileEntityDecoration)worldIn.func_175625_s(pos);
            if (playerIn.func_184586_b(hand).func_77973_b() == Items.field_151008_G) {
                deco.increaseHeight();
            } else if (playerIn.func_184586_b(hand).func_77973_b() == Items.field_151042_j) {
                deco.decreaseHeight();
            }
            worldIn.func_184138_a(pos, state, state, 8);
        }
        return true;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityDecoration) {
            ((TileEntityDecoration)tile).variant = stack.func_77960_j();
        }
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack itemstack = this.getData((TileEntityDecoration)worldIn.func_175625_s(pos));
        return itemstack != null ? itemstack : new ItemStack((Block)this);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityDecoration) {
            TileEntityDecoration deco = (TileEntityDecoration)te;
            BlockBookDecoration.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)this.getData(deco));
        } else {
            super.func_180657_a(worldIn, player, pos, state, (TileEntity)null, stack);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te = world.func_175625_s(pos);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (te instanceof TileEntityDecoration) {
            TileEntityDecoration deco = (TileEntityDecoration)te;
            ret.add(this.getData(deco));
        } else {
            ret.add(new ItemStack((Block)this, 1, 0));
        }
        return ret;
    }

    public ItemStack getData(TileEntityDecoration tile) {
        ItemStack stack = new ItemStack((Block)this, 1, tile.variant);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("Height", tile.height);
        tag.func_74768_a("Color", tile.color);
        stack.func_77982_d(tag);
        return stack;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int meta = 0; meta < TYPES.length; ++meta) {
            items.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityDecoration.class;
    }

    @SideOnly(value=Side.CLIENT)
    public TileEntitySpecialRenderer<?> getTileRenderer() {
        return new TileEntityDecorationRenderer();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        return tile instanceof TileEntityWithBook && ((TileEntityWithBook)tile).isOpen() ? 15 : 0;
    }
}

