/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ranged.IAmmo;

public final class AmmoHelper {
    private AmmoHelper() {
    }

    @Nonnull
    public static ItemStack findAmmoFromInventory(List<Item> ammoItems, Entity entity) {
        if (ammoItems == null || entity == null || !entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return ItemStack.field_190927_a;
        }
        IItemHandler itemHandler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
        ItemStack ammo = ItemStack.field_190927_a;
        if (itemHandler != null) {
            ammo = AmmoHelper.validAmmoInRange(itemHandler, ammoItems, 0, itemHandler.getSlots());
        }
        if (ammo.func_190926_b() && (itemHandler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) != null) {
            int hotbarSize = 0;
            if (entity instanceof EntityPlayer) {
                hotbarSize = Math.min(InventoryPlayer.func_70451_h(), itemHandler.getSlots());
                ammo = AmmoHelper.validAmmoInRange(itemHandler, ammoItems, 0, hotbarSize);
            }
            if (ammo.func_190926_b()) {
                ammo = AmmoHelper.validAmmoInRange(itemHandler, ammoItems, hotbarSize, itemHandler.getSlots());
            }
        }
        return ammo;
    }

    @Nonnull
    private static ItemStack validAmmoInRange(IItemHandler itemHandler, List<Item> ammoItems, int from, int to) {
        for (int i = from; i < to; ++i) {
            ItemStack in = itemHandler.getStackInSlot(i);
            for (Item ammoItem : ammoItems) {
                if (in.func_190926_b() || in.func_77973_b() != ammoItem || ammoItem instanceof IAmmo && ((IAmmo)ammoItem).getCurrentAmmo(in) <= 0) continue;
                return in;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack getMatchingItemstackFromInventory(ItemStack stack, Entity entity, boolean damagedOnly) {
        if (stack == null || !entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return ItemStack.field_190927_a;
        }
        if (entity instanceof EntityLivingBase) {
            ItemStack in = ((EntityLivingBase)entity).func_184614_ca();
            if (ToolCore.isEqualTinkersItem(in, stack) && (!damagedOnly || in.func_77952_i() > 0)) {
                return in;
            }
            in = ((EntityLivingBase)entity).func_184592_cb();
            if (ToolCore.isEqualTinkersItem(in, stack) && (!damagedOnly || in.func_77952_i() > 0)) {
                return in;
            }
        }
        IItemHandler itemHandler = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        assert (itemHandler != null);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack in = itemHandler.getStackInSlot(i);
            if (!ToolCore.isEqualTinkersItem(in, stack) || damagedOnly && in.func_77952_i() <= 0) continue;
            return in;
        }
        return ItemStack.field_190927_a;
    }
}

