/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.mixinbooter;

import com.google.common.base.Strings;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.ModAPIManager;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import zone.rong.mixinbooter.MixinBooterPlugin;

public class ConfigDecorators {
    public static final String MIXIN_LOCATION_DECORATOR = "sourceLocation";
    public static final String MOD_ID_DECORATOR = "modId";
    private static ASMDataTable asmDataTable;

    public static void prepareASMDataTable() {
        if (asmDataTable == null) {
            try {
                Field modApiManager$dataTable = ModAPIManager.class.getDeclaredField("dataTable");
                modApiManager$dataTable.setAccessible(true);
                asmDataTable = (ASMDataTable)modApiManager$dataTable.get(ModAPIManager.INSTANCE);
            }
            catch (ReflectiveOperationException e) {
                MixinBooterPlugin.LOGGER.fatal("Not able to reflect ModAPIManager#dataTable", (Throwable)e);
            }
        }
    }

    public static String getDecoratedMixinLocation(IMixinInfo mixinInfo) {
        return ConfigDecorators.getDecoratedMixinLocation(mixinInfo.getConfig(), "unknown-location");
    }

    public static String getDecoratedMixinLocation(IMixinConfig config) {
        return ConfigDecorators.getDecoratedMixinLocation(config, "unknown-location");
    }

    public static String getDecoratedMixinLocation(IMixinInfo mixinInfo, String defaultValue) {
        return ConfigDecorators.getDecoratedMixinLocation(mixinInfo.getConfig(), defaultValue);
    }

    public static String getDecoratedMixinLocation(IMixinConfig config, String defaultValue) {
        if (config.hasDecoration(MIXIN_LOCATION_DECORATOR)) {
            String location = (String)config.getDecoration(MIXIN_LOCATION_DECORATOR);
            return location.isEmpty() ? defaultValue : location;
        }
        String value = asmDataTable == null ? ConfigDecorators.getSanitizedModIdFromResource(config) : ConfigDecorators.getCandidates(config).stream().map(ModCandidate::getClassPathRoot).map(File::getName).findFirst().orElse("unknown");
        config.decorate(MIXIN_LOCATION_DECORATOR, value);
        return "unknown".equals(value) ? "unknown-source" : value;
    }

    public static String getDecoratedModId(IMixinInfo mixinInfo) {
        return ConfigDecorators.getDecoratedModId(mixinInfo.getConfig(), "unknown");
    }

    public static String getDecoratedModId(IMixinConfig config) {
        return ConfigDecorators.getDecoratedModId(config, "unknown");
    }

    public static String getDecoratedModId(IMixinInfo mixinInfo, String defaultValue) {
        return ConfigDecorators.getDecoratedModId(mixinInfo.getConfig(), defaultValue);
    }

    public static String getDecoratedModId(IMixinConfig config, String defaultValue) {
        if (config.hasDecoration(MOD_ID_DECORATOR)) {
            String location = (String)config.getDecoration(MOD_ID_DECORATOR);
            return location.isEmpty() ? defaultValue : location;
        }
        String value = asmDataTable == null ? ConfigDecorators.getSanitizedModIdFromResource(config) : ConfigDecorators.getCandidates(config).stream().map(ModCandidate::getContainedMods).flatMap(Collection::stream).map(ModContainer::getModId).filter(modId -> !Strings.isNullOrEmpty((String)modId)).findFirst().orElseGet(() -> ConfigDecorators.getSanitizedModIdFromResource(config));
        config.decorate(MOD_ID_DECORATOR, value);
        return value;
    }

    private static String getSanitizedModIdFromResource(IMixinConfig config) {
        String baseModId = ConfigDecorators.getResourceName(config);
        if ("unknown".equals(baseModId)) {
            return "unknown";
        }
        if (baseModId.endsWith(".jar") || baseModId.endsWith(".zip")) {
            baseModId = baseModId.substring(0, baseModId.length() - 4);
        }
        StringBuilder sanitizedModId = new StringBuilder();
        for (int i = 0; i < baseModId.length(); ++i) {
            char character = baseModId.charAt(i);
            if (character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || i > 0 && character >= '0' && character <= '9') {
                sanitizedModId.append(character);
                continue;
            }
            sanitizedModId.append('_');
        }
        return sanitizedModId.toString();
    }

    private static String getResourceName(IMixinConfig config) {
        String filePath;
        String[] parts;
        String resource = Launch.classLoader.getResource(config.getName()).getPath();
        if (resource.contains("!/") && (parts = (filePath = resource.split("!/")[0]).split("/")).length != 0) {
            return parts[parts.length - 1];
        }
        return "unknown";
    }

    private static Set<ModCandidate> getCandidates(IMixinConfig config) {
        String pkg = config.getMixinPackage();
        pkg = pkg.charAt(pkg.length() - 1) == '.' ? pkg.substring(0, pkg.length() - 1) : pkg;
        return asmDataTable.getCandidatesFor(pkg);
    }

    private ConfigDecorators() {
    }
}

