/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.gui.geometry;

import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.gui.geometry.MuseRect;
import net.machinemuse.numina.client.render.RenderState;
import net.machinemuse.numina.common.math.Colour;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public class DrawableTile
extends MuseRect {
    Colour backgroundColour;
    Colour borderColour;
    float lineWidth = 4.0f;
    boolean smoothing = true;

    public DrawableTile(double left, double top, double right, double bottom, boolean growFromMiddle, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, growFromMiddle);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public void setLineWidth(float lineWidthIn) {
        this.lineWidth = lineWidthIn;
    }

    public DrawableTile(double left, double top, double right, double bottom, Colour backgroundColour, Colour borderColour) {
        super(left, top, right, bottom, false);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    public DrawableTile(MusePoint2D ul, MusePoint2D br, Colour backgroundColour, Colour borderColour) {
        super(ul, br);
        this.backgroundColour = backgroundColour;
        this.borderColour = borderColour;
    }

    @Override
    public DrawableTile copyOf() {
        return new DrawableTile(super.left(), super.top(), super.right(), super.bottom(), this.backgroundColour, this.borderColour);
    }

    @Override
    public DrawableTile setLeft(double value) {
        super.setLeft(value);
        return this;
    }

    @Override
    public DrawableTile setRight(double value) {
        super.setRight(value);
        return this;
    }

    @Override
    public DrawableTile setTop(double value) {
        super.setTop(value);
        return this;
    }

    @Override
    public DrawableTile setBottom(double value) {
        super.setBottom(value);
        return this;
    }

    @Override
    public DrawableTile setWidth(double value) {
        super.setWidth(value);
        return this;
    }

    @Override
    public DrawableTile setHeight(double value) {
        super.setHeight(value);
        return this;
    }

    void vertices() {
        GlStateManager.func_187435_e((float)((float)this.left()), (float)((float)this.top()), (float)1.0f);
        GlStateManager.func_187435_e((float)((float)this.right()), (float)((float)this.top()), (float)1.0f);
        GlStateManager.func_187435_e((float)((float)this.right()), (float)((float)this.bottom()), (float)1.0f);
        GlStateManager.func_187435_e((float)((float)this.left()), (float)((float)this.bottom()), (float)1.0f);
    }

    public void setSmoothing(boolean smoothingIn) {
        this.smoothing = smoothingIn;
    }

    public void preDraw() {
        RenderState.on2D();
        RenderState.texturelessOn();
        if (this.smoothing) {
            GL11.glEnable((int)2848);
            GL11.glHint((int)3154, (int)4354);
        } else {
            GL11.glDisable((int)2848);
            GL11.glHint((int)3154, (int)4353);
        }
    }

    public void postDraw() {
        Colour.WHITE.doGL();
        RenderState.texturelessOff();
        RenderState.glowOff();
    }

    public void draw() {
        float lineWidth = GL11.glGetFloat((int)2849);
        boolean smooth = GL11.glIsEnabled((int)2848);
        this.preDraw();
        GL11.glBegin((int)9);
        this.backgroundColour.doGL();
        this.vertices();
        GL11.glEnd();
        GL11.glLineWidth((float)lineWidth);
        GL11.glBegin((int)2);
        this.borderColour.doGL();
        this.vertices();
        GL11.glEnd();
        this.postDraw();
        if (!smooth) {
            GL11.glDisable((int)2848);
        }
        GL11.glLineWidth((float)lineWidth);
    }

    public DrawableTile setBackgroundColour(Colour insideColour) {
        this.backgroundColour = insideColour;
        return this;
    }

    public DrawableTile setBorderColour(Colour outsideColour) {
        this.borderColour = outsideColour;
        return this;
    }
}

