/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.gui.clickable;

import java.util.List;
import net.machinemuse.numina.client.gui.clickable.Clickable;
import net.machinemuse.numina.client.gui.geometry.DrawableMuseRect;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.common.math.Colour;

public class ClickableButton
extends Clickable {
    public String label;
    protected MusePoint2D radius;
    protected DrawableMuseRect rect;
    protected boolean enabled;
    protected boolean visible = true;

    public ClickableButton(String label, MusePoint2D position, boolean enabled) {
        this.label = label;
        this.position = position;
        this.radius = new MusePoint2D(MuseRenderer.getStringWidth(label) / 2.0 + 2.0, 6.0);
        this.rect = new DrawableMuseRect(position.getX() - this.radius.getX(), position.getY() - this.radius.getY(), position.getX() + this.radius.getX(), position.getY() + this.radius.getY(), new Colour(0.5, 0.6f, 0.8f, 1.0), new Colour(0.3f, 0.3f, 0.3f, 1.0));
        this.setEnabled(enabled);
    }

    @Override
    public void render(double mouseX, double mouseY, float partialTicks) {
        if (this.visible) {
            Colour bottomcolour;
            Colour topcolour;
            if (this.isEnabled()) {
                topcolour = new Colour(0.5, 0.6f, 0.8f, 1.0);
                bottomcolour = new Colour(0.3f, 0.3f, 0.3f, 1.0);
            } else {
                topcolour = new Colour(0.8f, 0.3f, 0.3f, 1.0);
                bottomcolour = new Colour(0.8f, 0.6f, 0.6f, 1.0);
            }
            this.rect.setLeft(this.position.getX() - this.radius.getX());
            this.rect.setTop(this.position.getY() - this.radius.getY());
            this.rect.setRight(this.position.getX() + this.radius.getX());
            this.rect.setBottom(this.position.getY() + this.radius.getY());
            this.rect.setOutsideColour(topcolour);
            this.rect.setInsideColour(bottomcolour);
            this.rect.render(mouseX, mouseY, partialTicks);
            MuseRenderer.drawCenteredString(this.label, this.position.getX(), this.position.getY() - 4.0);
        }
    }

    @Override
    public boolean containsPoint(double mouseX, double mouseY) {
        boolean hitx = Math.abs(this.position.getX() - mouseX) < this.radius.getX();
        boolean hity = Math.abs(this.position.getY() - mouseY) < this.radius.getY();
        return hitx && hity;
    }

    @Override
    public List<String> getToolTip(double mouseX, double mouseY) {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public ClickableButton setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Override
    public void enable() {
        this.enabled = true;
    }

    public void buttonOn() {
        this.enable();
        this.show();
    }

    public void buttonOff() {
        this.disable();
        this.hide();
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public void show() {
        this.visible = true;
    }

    @Override
    public void hide() {
        this.visible = false;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public ClickableButton setLable(String label) {
        this.label = label;
        return this;
    }

    public String getLabel() {
        return this.label;
    }
}

