/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.gui.clickable;

import java.util.List;
import net.machinemuse.numina.client.gui.clickable.IClickable;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;

public abstract class Clickable
implements IClickable {
    IClickable.IPressable onPressed;
    IClickable.IReleasable onReleased;
    protected MusePoint2D position;
    protected boolean enabled = true;
    protected boolean visible = true;

    public Clickable() {
        this.position = new MusePoint2D(0.0, 0.0);
    }

    public Clickable(MusePoint2D point) {
        this.position = point;
    }

    @Override
    public MusePoint2D getPosition() {
        return this.position;
    }

    public void setPosition(MusePoint2D position) {
        this.position = position;
    }

    @Override
    public void move(double x, double y) {
        this.position.setX(x);
        this.position.setY(y);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public List<String> getToolTip(double mouseX, double mouseY) {
        return null;
    }

    @Override
    public void show() {
        this.visible = true;
    }

    @Override
    public void hide() {
        this.visible = false;
    }

    @Override
    public void enable() {
        this.enabled = true;
    }

    @Override
    public void disable() {
        this.enabled = false;
    }

    @Override
    public void setOnPressed(IClickable.IPressable onPressed) {
        this.onPressed = onPressed;
    }

    @Override
    public void setOnReleased(IClickable.IReleasable onReleased) {
        this.onReleased = onReleased;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled() && this.onPressed != null) {
            this.onPressed.onPressed(this);
        }
    }

    @Override
    public void onReleased() {
        if (this.isVisible() && this.isEnabled() && this.onReleased != null) {
            this.onReleased.onReleased(this);
        }
    }
}

