/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.numina.client.gui.clickable;

import java.util.List;
import net.machinemuse.numina.client.gui.clickable.Clickable;
import net.machinemuse.numina.client.gui.geometry.DrawableTile;
import net.machinemuse.numina.client.gui.geometry.MusePoint2D;
import net.machinemuse.numina.client.render.MuseRenderer;
import net.machinemuse.numina.common.math.Colour;

public class CheckBox
extends Clickable {
    protected boolean isChecked;
    protected DrawableTile tile;
    String label;
    final int id;

    public CheckBox(int id, MusePoint2D position, String displayString, boolean isChecked) {
        this.id = id;
        MusePoint2D ul = position.plus(4.0, 4.0);
        this.tile = new DrawableTile(ul, ul.plus(8.0, 8.0), Colour.BLACK, Colour.DARKGREY);
        this.label = displayString;
        this.isChecked = isChecked;
        this.tile.setSmoothing(false);
    }

    @Override
    public void render(double mouseX, double mouseY, float partialTicks) {
        this.tile.draw();
        if (this.isChecked) {
            MuseRenderer.drawString("x", this.tile.centerX() - 2.0, this.tile.centerY() - 5.0, Colour.WHITE);
        }
        MuseRenderer.drawString(this.label, this.tile.centerX() + 8.0, this.tile.centerY() - 4.0, Colour.WHITE);
    }

    public int getId() {
        return this.id;
    }

    @Override
    public boolean containsPoint(double mouseX, double mouseY) {
        return this.tile.containsPoint(mouseX, mouseY);
    }

    @Override
    public void move(double x, double y) {
        this.setPosition(this.getPosition().plus(x, y));
    }

    @Override
    public void setPosition(MusePoint2D position) {
        super.setPosition(position);
        this.tile.setPosition(position);
    }

    @Override
    public List<String> getToolTip(double mouseX, double mouseY) {
        return null;
    }

    @Override
    public void onPressed() {
        if (this.isVisible() && this.isEnabled()) {
            this.isChecked = !this.isChecked;
        }
        super.onPressed();
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void setChecked(boolean checked) {
        this.isChecked = checked;
    }
}

