/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.network;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.network.IServerMessageReceiver;
import com.charles445.rltweaker.util.ErrorUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ServerMessageHandler {
    public static Map<Class, IServerMessageReceiver> registeredMessages = new ConcurrentHashMap<Class, IServerMessageReceiver>();

    public static void registerMessage(Class message, IServerMessageReceiver receiver) {
        if (IMessage.class.isAssignableFrom(message)) {
            registeredMessages.put(message, receiver);
        } else {
            RLTweaker.logger.error("Failed to ServerMessageHandler register message of class, not an IMessage: " + message.getName());
        }
    }

    private static void executeRegisteredMessage(IMessage message, EntityPlayer player) {
        IServerMessageReceiver receiver = registeredMessages.get(message.getClass());
        if (receiver == null) {
            return;
        }
        receiver.receiveMessage(message, player);
    }

    public static IMessage executeMessage(IMessage message, MessageContext ctx) {
        if (ctx.side == Side.SERVER && ctx.netHandler instanceof NetHandlerPlayServer) {
            NetHandlerPlayServer netHandler = (NetHandlerPlayServer)ctx.netHandler;
            if (netHandler.field_147369_b != null) {
                netHandler.field_147369_b.func_71121_q().func_152344_a(() -> ServerMessageHandler.executeRegisteredMessage(message, (EntityPlayer)netHandler.field_147369_b));
            } else {
                RLTweaker.logger.error("NetHandlerPlayServer had null player...");
                ErrorUtil.logSilent("NetHandlerPlayServer NULL PLAYER");
            }
        }
        return null;
    }
}

