/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.QuarkReflect;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class QuarkHandler {
    QuarkReflect reflector;

    public QuarkHandler() {
        block2: {
            try {
                this.reflector = new QuarkReflect();
                CompatUtil.wrapSpecificHandler("QKAncientTomeAnvilUpdate", x$0 -> new QKAncientTomeAnvilUpdate((IEventListener)x$0), "vazkii.quark.misc.feature.AncientTomes", "onAnvilUpdate");
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup PotionCoreHandlerClient!", (Throwable)e);
                ErrorUtil.logSilent("PotionCore Client Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    public class QKAncientTomeAnvilUpdate {
        private IEventListener handler;

        public QKAncientTomeAnvilUpdate(IEventListener handler) {
            this.handler = handler;
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @SubscribeEvent
        public void onUseItem(PlayerInteractEvent.RightClickItem event) {
            if (event.getHand() != EnumHand.MAIN_HAND || !ModConfig.server.quark.ancientTomesAlternateBehavior) {
                return;
            }
            EntityPlayer player = event.getEntityPlayer();
            if (player == null) {
                return;
            }
            ItemStack offhandStack = player.func_184592_cb();
            if (offhandStack.func_190926_b()) {
                return;
            }
            ItemStack mainhandStack = player.func_184614_ca();
            if (mainhandStack.func_190926_b() || mainhandStack.func_77973_b() == Items.field_151134_bR) {
                return;
            }
            try {
                Item ancient_tome = QuarkHandler.this.reflector.getAncientTomeItem();
                if (ancient_tome == null) {
                    ErrorUtil.logSilent("Quark AncientTomes Item Null");
                    return;
                }
                if (offhandStack.func_77973_b() != ancient_tome) {
                    return;
                }
                if (mainhandStack.func_77973_b() == ancient_tome) {
                    return;
                }
                Map tomeEnchants = EnchantmentHelper.func_82781_a((ItemStack)offhandStack);
                Map itemEnchants = EnchantmentHelper.func_82781_a((ItemStack)mainhandStack);
                boolean matched = false;
                for (Map.Entry entry : tomeEnchants.entrySet()) {
                    Integer val;
                    Enchantment enchant = (Enchantment)entry.getKey();
                    if (enchant == null || (val = (Integer)itemEnchants.get(enchant)) == null || val != entry.getValue()) continue;
                    itemEnchants.put(enchant, val + 1);
                    matched = true;
                }
                if (matched) {
                    ItemStack returnStack = mainhandStack.func_77946_l();
                    EnchantmentHelper.func_82782_a((Map)itemEnchants, (ItemStack)returnStack);
                    player.func_184611_a(EnumHand.MAIN_HAND, returnStack);
                    player.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
                    if (player.field_70170_p != null && !player.field_70170_p.field_72995_K) {
                        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_190021_aL, SoundCategory.BLOCKS, 0.7f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                ErrorUtil.logSilent("Quark AncientTomes Invocation");
                return;
            }
        }

        @SubscribeEvent
        public void anvilUpdate(AnvilUpdateEvent event) {
            if (!ModConfig.server.quark.ancientTomesAlternateBehavior) {
                this.handler.invoke((Event)event);
                return;
            }
        }
    }
}

