/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.util.CompatUtil;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import com.charles445.rltweaker.util.ServerRunnable;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DynamicSurroundingsHandler {
    @Nullable
    EnvironmentServiceHelper environmentServiceHelper;

    public DynamicSurroundingsHandler() {
        if (ModConfig.server.dynamicsurroundings.environmentServiceDelay) {
            this.environmentServiceHelper = new EnvironmentServiceHelper();
            RLTweaker.serverRunnables.put("EnvironmentServiceHelper", this.environmentServiceHelper);
        }
    }

    public class EnvironmentServiceHelper
    implements ServerRunnable {
        IEventListener handler_tickEvent;

        @Override
        public void onServerStarting() {
            block2: {
                try {
                    this.handler_tickEvent = (IEventListener)CompatUtil.findAndRemoveHandlerFromEventBus("org.orecruncher.dsurround.server.services.EnvironmentService", "tickEvent");
                    MinecraftForge.EVENT_BUS.register((Object)this);
                }
                catch (Exception e) {
                    ErrorUtil.logSilent("DynamicSurroundings EnvironmentServiceHelper Wrapper");
                    if (!(e instanceof CriticalException)) break block2;
                    throw new RuntimeException("Critical error setting up EnvironmentServiceHelper!", e);
                }
            }
        }

        @Override
        public void onServerStopping() {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.handler_tickEvent = null;
        }

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (this.handler_tickEvent != null && event.player.field_70173_aa % 20 == 0) {
                this.handler_tickEvent.invoke((Event)event);
            }
        }
    }
}

