/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.handler;

import com.charles445.rltweaker.RLTweaker;
import com.charles445.rltweaker.config.ModConfig;
import com.charles445.rltweaker.reflect.AquacultureReflect;
import com.charles445.rltweaker.util.CriticalException;
import com.charles445.rltweaker.util.ErrorUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.world.biome.Biome;

public class AquacultureHandler {
    private AquacultureReflect reflector;

    public AquacultureHandler() {
        block4: {
            try {
                this.reflector = new AquacultureReflect();
                if (ModConfig.server.aquaculture.fixNeptunesBounty) {
                    this.fixNeptunesBounty();
                }
                if (ModConfig.server.aquaculture.fixFreshwaterBug) {
                    this.fixFreshwaterBug();
                }
            }
            catch (Exception e) {
                RLTweaker.logger.error("Failed to setup AquacultureHandler!", (Throwable)e);
                ErrorUtil.logSilent("Aquaculture Critical Setup Failure");
                if (!(e instanceof CriticalException)) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public void fixFreshwaterBug() {
        try {
            Map<Integer, ArrayList<Object>> biomeMap = this.reflector.getBiomeMap();
            if (biomeMap == null) {
                RLTweaker.logger.error("Aquaculture had null biomeMap, failed to fix freshwater bug");
                ErrorUtil.logSilent("Aquaculture Fix Freshwater Bug Null BiomeMap");
                return;
            }
            Object freshwaterBiomeType = this.reflector.getFreshwaterBiomeType();
            if (freshwaterBiomeType == null) {
                RLTweaker.logger.error("Aquaculture had null freshwater BiomeType, failed to fix freshwater bug");
                ErrorUtil.logSilent("Aquaculture Fix Freshwater Bug Null Freshwater BiomeType");
                return;
            }
            for (Biome biome : Biome.field_185377_q) {
                int biomeID = Biome.func_185362_a((Biome)biome);
                if (biomeMap.containsKey(biomeID)) continue;
                biomeMap.put(biomeID, new ArrayList());
                biomeMap.get(biomeID).add(freshwaterBiomeType);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            ErrorUtil.logSilent("Aquaculture Fix Freshwater Bug Failure");
        }
    }

    public void fixNeptunesBounty() {
        try {
            if (!this.reflector.getNeptuniumLootEnabled()) {
                return;
            }
            this.reflector.addLoot(this.reflector.getNeptunesBountyLoot(), this.reflector.getNeptuniumBarStack(), 2, 1, 4);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            ErrorUtil.logSilent("Aquaculture Neptunes Bounty Loot Failure");
        }
    }
}

