/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.rltweaker.client.gui;

import com.charles445.rltweaker.client.gui.IGuiDelegate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiDelegator {
    public static Map<String, List<IGuiDelegate>> delegates = new ConcurrentHashMap<String, List<IGuiDelegate>>();
    private Minecraft mc = Minecraft.func_71410_x();

    public GuiDelegator() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void addDelegate(String guiClazz, IGuiDelegate delegate) {
        List<IGuiDelegate> delegateList = delegates.get(guiClazz);
        if (delegateList == null) {
            delegateList = new ArrayList<IGuiDelegate>();
            delegates.put(guiClazz, delegateList);
        }
        delegateList.add(delegate);
    }

    @SubscribeEvent
    public void onMouseInputPre(GuiScreenEvent.MouseInputEvent.Pre event) {
        try {
            this.pollMousePre(event);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void pollMousePre(GuiScreenEvent.MouseInputEvent.Pre event) throws IOException {
        GuiScreen guiScreen = event.getGui();
        List<IGuiDelegate> delegateList = delegates.get(guiScreen.getClass().getName());
        if (delegateList == null) {
            return;
        }
        int width = guiScreen.field_146294_l;
        int height = guiScreen.field_146295_m;
        int x = Mouse.getEventX() * width / this.mc.field_71443_c;
        int y = height - Mouse.getEventY() * height / this.mc.field_71440_d - 1;
        int button = Mouse.getEventButton();
        boolean state = Mouse.getEventButtonState();
        for (IGuiDelegate delegate : delegateList) {
            if (!delegate.pollMousePre(guiScreen, width, height, x, y, button, state)) continue;
            event.setCanceled(true);
            return;
        }
    }

    private void message(String s) {
        if (this.mc.field_71439_g != null) {
            this.mc.field_71439_g.func_145747_a((ITextComponent)new TextComponentString(s));
        }
    }
}

