/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.items.weapons;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.silvercatcher.reforged.api.ExtendedItem;
import org.silvercatcher.reforged.material.MaterialDefinition;
import org.silvercatcher.reforged.material.MaterialManager;

public class ItemPike
extends ExtendedItem {
    protected final MaterialDefinition materialDefinition;
    protected final boolean unbreakable;

    public ItemPike(Item.ToolMaterial material) {
        this(material, false);
    }

    public ItemPike(Item.ToolMaterial material, boolean unbreakable) {
        this.unbreakable = unbreakable;
        this.func_77625_d(1);
        this.materialDefinition = MaterialManager.getMaterialDefinition(material);
        this.func_77656_e((int)((float)this.materialDefinition.getMaxUses() * 0.5f));
        this.func_77655_b(this.materialDefinition.getPrefixedName("pike"));
    }

    @Override
    public float getHitDamage() {
        return this.materialDefinition.getDamageVsEntity() + 5.0f;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.materialDefinition.getEnchantability();
    }

    public Item.ToolMaterial getMaterial() {
        return this.materialDefinition.getMaterial();
    }

    public MaterialDefinition getMaterialDefinition() {
        return this.materialDefinition;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        float damage = this.getHitDamage();
        if (attacker instanceof EntityPlayer) {
            damage += this.getEnchantmentBonus(stack, (Entity)target);
        }
        if (attacker.func_184218_aH()) {
            damage += this.getHitDamage() / 2.0f;
        }
        target.func_70097_a(this.getDamage(attacker), damage);
        if (stack.func_77973_b().func_77645_m()) {
            stack.func_77972_a(1, attacker);
        }
        return true;
    }

    public boolean func_77645_m() {
        return !this.unbreakable;
    }
}

