/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.items.weapons;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import org.silvercatcher.reforged.api.ExtendedItem;
import org.silvercatcher.reforged.entities.EntityBoomerang;
import org.silvercatcher.reforged.material.MaterialDefinition;
import org.silvercatcher.reforged.material.MaterialManager;
import org.silvercatcher.reforged.util.Helpers;

public class ItemBoomerang
extends ExtendedItem {
    protected final MaterialDefinition materialDefinition;
    protected final boolean unbreakable;

    public ItemBoomerang(Item.ToolMaterial material) {
        this(material, false);
    }

    public ItemBoomerang(Item.ToolMaterial material, boolean unbreakable) {
        this.unbreakable = unbreakable;
        this.func_77625_d(1);
        this.materialDefinition = MaterialManager.getMaterialDefinition(material);
        this.func_77656_e((int)((float)this.materialDefinition.getMaxUses() * 0.8f));
        this.func_77655_b(this.materialDefinition.getPrefixedName("boomerang"));
    }

    @Override
    public float getHitDamage() {
        return Math.max(1.0f, 0.5f + this.materialDefinition.getDamageVsEntity() / 2.0f);
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.materialDefinition.getEnchantability();
    }

    public Item.ToolMaterial getMaterial() {
        return this.materialDefinition.getMaterial();
    }

    public MaterialDefinition getMaterialDefinition() {
        return this.materialDefinition;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (stack.func_77973_b().func_77645_m()) {
            stack.func_77972_a(1, attacker);
        }
        return true;
    }

    public boolean func_77645_m() {
        return !this.unbreakable;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack throwStack = playerIn.func_184614_ca().func_77946_l();
            if (playerIn.field_71075_bZ.field_75098_d || Helpers.consumeInventoryItem(playerIn, (Item)this)) {
                Helpers.playSound(worldIn, (Entity)playerIn, "boomerang_throw", 0.5, 1.0);
                if (!worldIn.field_72995_K) {
                    EntityBoomerang boomerang = new EntityBoomerang(worldIn, (EntityLivingBase)playerIn, throwStack);
                    worldIn.func_72838_d((Entity)boomerang);
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184614_ca());
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)playerIn.func_184592_cb());
    }
}

