/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.items.weapons;

import com.google.common.collect.Multimap;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.silvercatcher.reforged.ReforgedMod;
import org.silvercatcher.reforged.api.IZombieEquippable;
import org.silvercatcher.reforged.api.ItemExtension;
import org.silvercatcher.reforged.material.MaterialDefinition;
import org.silvercatcher.reforged.material.MaterialManager;

public class ItemBattleAxe
extends ItemAxe
implements ItemExtension,
IZombieEquippable {
    protected final MaterialDefinition materialDefinition;
    protected final boolean unbreakable;

    public ItemBattleAxe(Item.ToolMaterial material) {
        this(material, false);
    }

    public ItemBattleAxe(Item.ToolMaterial material, boolean unbreakable) {
        super(material, material.func_78000_c() * 1.5f + 4.0f, -3.0f);
        this.func_77625_d(1);
        this.unbreakable = unbreakable;
        this.materialDefinition = MaterialManager.getMaterialDefinition(material);
        this.func_77655_b(this.materialDefinition.getPrefixedName("battleaxe"));
        this.func_77656_e(this.materialDefinition.getMaxUses());
        this.func_77637_a(ReforgedMod.tabReforged);
    }

    protected boolean effectiveAgainst(IBlockState target) {
        Material material = target.func_185904_a();
        return material == Material.field_151575_d || material == Material.field_151585_k || material == Material.field_151582_l;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        return ItemExtension.super.getAttributeModifiers(stack);
    }

    @Override
    public float getHitDamage() {
        return this.materialDefinition.getDamageVsEntity() * 1.5f + 4.0f;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.materialDefinition.getEnchantability();
    }

    public float func_150893_a(ItemStack stack, IBlockState block) {
        return this.effectiveAgainst(block) ? this.materialDefinition.getEfficiencyOnProperMaterial() + 0.5f : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (stack.func_77973_b().func_77645_m()) {
            stack.func_77972_a(1, attacker);
        }
        return true;
    }

    public boolean func_77645_m() {
        return !this.unbreakable;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase playerIn) {
        if (stack.func_77973_b().func_77645_m()) {
            stack.func_77972_a(this.effectiveAgainst(blockIn) ? 2 : 3, playerIn);
        }
        return true;
    }

    @Override
    public float zombieSpawnChance() {
        switch (this.materialDefinition.getMaterial()) {
            case GOLD: {
                return 1.0f;
            }
            case IRON: {
                return 2.0f;
            }
            case STONE: {
                return 3.0f;
            }
            case WOOD: {
                return 4.0f;
            }
        }
        return 0.0f;
    }
}

