/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.silvercatcher.reforged.api.AReloadable;
import org.silvercatcher.reforged.util.Helpers;

public class ReloadOverlay
extends Gui {
    private final Minecraft minecraft = Minecraft.func_71410_x();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderReload(RenderGameOverlayEvent.Pre event) {
        ItemStack equipped;
        Item equippedItem;
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        EntityPlayerSP player = this.minecraft.field_71439_g;
        if (player != null && player.field_70170_p != null && (equippedItem = (equipped = player.field_71071_by.func_70448_g()).func_77973_b()) instanceof AReloadable) {
            AReloadable reloadable = (AReloadable)equippedItem;
            int reloadTime = reloadable.getReloadTime(equipped);
            if (reloadTime <= 0 || reloadTime >= reloadable.getReloadTotal()) {
                return;
            }
            float done = Math.min((float)reloadTime / (float)reloadable.getReloadTotal(), 1.0f);
            int x0 = event.getResolution().func_78326_a() / 2 - 88 + player.field_71071_by.field_70461_c * 20;
            int y0 = event.getResolution().func_78328_b() - 3;
            int color = MathHelper.func_181758_c((float)(done / 3.0f), (float)1.0f, (float)1.0f);
            Helpers.drawRectangle(x0, y0 - (int)(done * 16.0f), x0 + 16, y0, new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f});
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179147_l();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void modifyFov(FOVUpdateEvent event) {
        EntityPlayer player = event.getEntity();
        if (!player.func_184587_cr()) {
            return;
        }
        ItemStack activeStack = player.func_184607_cu();
        Item activeItem = activeStack.func_77973_b();
        if (!(activeItem instanceof AReloadable)) {
            return;
        }
        AReloadable reloadable = (AReloadable)activeItem;
        if (reloadable.getReloadTime(activeStack) < reloadable.getReloadTotal()) {
            return;
        }
        int useTicks = player.func_184612_cw();
        if (useTicks >= 20) {
            event.setNewfov(event.getNewfov() * 0.8f);
        } else {
            float mod = (float)useTicks / 20.0f;
            event.setNewfov(event.getNewfov() * (1.0f - mod * mod * 0.2f));
        }
    }
}

