/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged.api;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.silvercatcher.reforged.ReforgedMod;
import org.silvercatcher.reforged.api.CompoundTags;
import org.silvercatcher.reforged.api.ItemExtension;
import org.silvercatcher.reforged.util.Helpers;

public abstract class AReloadable
extends Item
implements ItemExtension {
    private final String shootSound;
    private final String reloadSound;

    public AReloadable(String name, String shootSound, String reloadSound) {
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.func_77655_b(name);
        this.func_77637_a(ReforgedMod.tabReforged);
        this.shootSound = shootSound;
        this.reloadSound = reloadSound;
        this.func_185043_a(new ResourceLocation("loading"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack && stack.func_77942_o() && CompoundTags.giveCompound(stack).func_74762_e("time") < AReloadable.this.getReloadTotal() ? 1.0f : 0.0f;
            }
        });
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        int reloadTime = this.getReloadTime(stack);
        tooltip.add(I18n.func_135052_a((String)"item.musket.loadstate", (Object[])new Object[0]) + ": " + (reloadTime <= 0 ? I18n.func_135052_a((String)"item.musket.loadstate.empty", (Object[])new Object[0]) : (reloadTime >= this.getReloadTotal() ? I18n.func_135052_a((String)"item.musket.loadstate.loaded", (Object[])new Object[0]) : I18n.func_135052_a((String)"item.musket.loadstate.loading", (Object[])new Object[0]))));
    }

    public abstract Item getAmmo();

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(ItemStack stack) {
        return ItemExtension.super.getAttributeModifiers(stack);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getHitDamage(), 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getAttackSpeed(null), 0));
        }
        return multimap;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        int reloadTime = this.getReloadTime(stack);
        if (reloadTime <= 0) {
            return EnumAction.NONE;
        }
        if (reloadTime >= this.getReloadTotal()) {
            return EnumAction.BOW;
        }
        return ReforgedMod.battlegearDetected ? EnumAction.BOW : EnumAction.BLOCK;
    }

    public int getReloadTime(ItemStack stack) {
        return this.giveCompound(stack).func_74762_e("time");
    }

    public abstract int getReloadTotal();

    public NBTTagCompound giveCompound(ItemStack stack) {
        return CompoundTags.giveCompound(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack heldStack = playerIn.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)heldStack);
        }
        NBTTagCompound compound = this.giveCompound(heldStack);
        if (compound.func_74762_e("time") <= 0) {
            Item ammo = this.getAmmo();
            if (playerIn.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)heldStack) > 0 && Helpers.hasItem(playerIn, ammo) || Helpers.consumeInventoryItem(playerIn, ammo)) {
                Helpers.playSound(worldIn, (Entity)playerIn, this.reloadSound, 1.0f, 1.5f);
                compound.func_74768_a("time", 1);
            } else {
                Helpers.playSound(worldIn, (Entity)playerIn, this.reloadSound, 1.0f, 0.7f);
                return new ActionResult(EnumActionResult.FAIL, (Object)heldStack);
            }
        }
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.PASS, (Object)heldStack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound compound = this.giveCompound(stack);
        int reloadTime = compound.func_74762_e("time");
        if (reloadTime < this.getReloadTotal()) {
            if (reloadTime == this.getReloadTotal() - 1) {
                if (!player.field_70170_p.field_72995_K) {
                    compound.func_74768_a("time", this.getReloadTotal());
                    player.func_184602_cy();
                    Helpers.playSound(player.field_70170_p, (Entity)player, this.reloadSound, 1.0f, 1.0f);
                    if (player instanceof EntityPlayer) {
                        ((EntityPlayer)player).func_184811_cZ().func_185145_a((Item)this, 10);
                    }
                }
            } else {
                compound.func_74768_a("time", reloadTime + 1);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase playerInl, int timeLeft) {
        if (!(playerInl instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer playerIn = (EntityPlayer)playerInl;
        NBTTagCompound compound = this.giveCompound(stack);
        if (compound.func_74762_e("time") >= this.getReloadTotal()) {
            if (!worldIn.field_72995_K) {
                this.shoot(worldIn, (EntityLivingBase)playerIn, stack);
                if (!playerIn.field_71075_bZ.field_75098_d && stack.func_77973_b().func_77645_m() && stack.func_96631_a(5, field_77697_d, playerIn instanceof EntityPlayerMP ? (EntityPlayerMP)playerIn : null)) {
                    playerIn.func_70669_a(stack);
                    Helpers.destroyCurrentEquippedItem(playerIn);
                }
            }
            compound.func_74768_a("time", 0);
            Helpers.playSound(worldIn, (Entity)playerIn, this.shootSound, 1.0f, 1.0f);
        }
    }

    public abstract void shoot(World var1, EntityLivingBase var2, ItemStack var3);

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (super.canContinueUsing(oldStack, newStack)) {
            return true;
        }
        if (oldStack.func_77973_b() != newStack.func_77973_b() || !oldStack.func_77942_o() || !newStack.func_77942_o()) {
            return false;
        }
        int oldReloadTime = CompoundTags.giveCompound(oldStack).func_74762_e("time");
        int newReloadTime = CompoundTags.giveCompound(newStack).func_74762_e("time");
        if (oldReloadTime == 0 || newReloadTime == 0) {
            return false;
        }
        if (oldReloadTime < this.getReloadTotal()) {
            return newReloadTime < this.getReloadTotal();
        }
        return newReloadTime >= this.getReloadTotal();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

