/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.conduit.data;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.invpanel.capability.IDatabaseHandler;
import crazypants.enderio.base.invpanel.capability.InventoryDatabaseSource;
import crazypants.enderio.base.invpanel.database.IInventoryDatabaseServer;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.invpanel.conduit.data.IDataConduit;
import crazypants.enderio.invpanel.server.InventoryDatabaseServer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class DataConduitNetwork
extends AbstractConduitNetwork<IDataConduit, IDataConduit>
implements IDatabaseHandler {
    @Nonnull
    private final NNList<InventoryDatabaseSource> inventories = new NNList();
    @Nullable
    private IInventoryDatabaseServer database = null;
    private int changeCount = 0;

    public DataConduitNetwork() {
        super(IDataConduit.class, IDataConduit.class);
    }

    @Override
    public void addConduit(@Nonnull IDataConduit con) {
        super.addConduit(con);
        for (EnumFacing dir : con.getExternalConnections()) {
            con.checkConnections(dir);
        }
    }

    public void addSource(@Nonnull InventoryDatabaseSource source) {
        if (!this.inventories.contains((Object)source)) {
            this.inventories.add((Object)source);
            ++this.changeCount;
        }
    }

    public void removeSource(InventoryDatabaseSource source) {
        if (source != null) {
            this.inventories.remove((Object)source);
            ++this.changeCount;
        }
    }

    @Override
    @Nonnull
    public IInventoryDatabaseServer getDatabase() {
        block4: {
            block3: {
                block2: {
                    if (this.database != null) break block2;
                    this.database = new InventoryDatabaseServer(this);
                    break block3;
                }
                if (this.database.isCurrent()) break block4;
            }
            this.database.updateNetworkSources();
        }
        return this.database;
    }

    @Override
    public int getChangeCount() {
        return this.changeCount;
    }

    @Override
    @Nonnull
    public List<InventoryDatabaseSource> getSources() {
        return this.inventories;
    }

    @Override
    public void destroyNetwork() {
        super.destroyNetwork();
        if (this.database != null) {
            this.database.resetDatabase();
            this.database = null;
        }
    }

    @Override
    public void tickStart(TickEvent.ServerTickEvent event, @Nullable Profiler profiler) {
        super.tickStart(event, profiler);
    }
}

